import { type TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { type IRevision } from '@/shared/types/flottes/revision';
import { INITIAL_REVISION_DATA } from '@/shared/_mock/flottes/_revision';

const revisionTabsConfig: TabConfig<IRevision> = {
  type: 'révision',
  listTitle: 'Liste des révisions / entretiens',
  newItemTitle: 'Nouvelle révision / entretien',
  initialData: INITIAL_REVISION_DATA,
  getItemCode: (revision) => revision.immatriculation,
};

export function useRevisionTabs() {
  return useTabsManager<IRevision>(revisionTabsConfig);
} 