import { type FormFieldType } from '@/shared/types/common';
import { type IRevision, StatutCT, UserType } from '@/shared/types/flottes/revision';
import { 
  faHashtag,
  faUser,
  faCalendarDay,
  faMapMarkerAlt,
  faNoteSticky,
  faTachometerAlt,
  faFileAlt,
  faCarSide,
  faWrench,
} from '@fortawesome/free-solid-svg-icons';
import { IMMATRICULATIONS } from '@/shared/_mock';
import { _garageRevisions, _responsables } from '@/shared/_mock/flottes/_revision';
import { Option } from '@/shared/sections/circuit/utils/form-fields-circuit';
import { NOMS_FOURNISSEUR } from '@/shared/_mock/flottes/_supplier';

export const revisionFormFields = (interventionsOptions: Option[]): FormFieldType<IRevision>[] => [
  {
    name: 'immatriculation',
    label: 'Immatriculation',
    type: 'combobox',
    required: true,
    options: IMMATRICULATIONS.map((immat) => ({ value: immat, label: immat })),
    placeholder: 'Choisissez une immatriculation',
    icon: faCarSide,
  },
  {
    name: 'type',
    label: 'Type',
    type: 'select',
    required: true,
    options: Object.values(UserType).map((type) => ({ value: type, label: type })),
    placeholder: 'Choisissez un type',
    icon: faUser,
  },
  {
    name: 'personne',
    label: 'Personne',
    type: 'combobox',
    required: true,
    options: _responsables.map((resp) => ({ value: resp, label: resp })),
    placeholder: 'Choisissez une personne',
    icon: faUser,
  },
  {
    name: 'dateRevision',
    label: 'Date Révision',
    type: 'date',
    required: true,
    icon: faCalendarDay,
  },
  {
    name: 'garageRevision',
    label: 'Garage Révision',
    type: 'combobox',
    required: true,
    options: _garageRevisions.map((garage) => ({ value: garage, label: garage })),
    placeholder: 'Choisissez un garage',
    icon: faWrench,
  },
  {
    name: 'adresse',
    label: 'Adresse',
    type: 'text',
    required: true,
    placeholder: 'Entrez l\'adresse du garage',
    icon: faMapMarkerAlt,
  },
  {
    name: "supplier",
    label: "Fournisseur",
    type: "select",
    placeholder: "Choisissez un fournisseur",
    options: NOMS_FOURNISSEUR.map((supplier) => ({
      label: supplier,
      value: supplier,
    })),
  },
  {
    name: "intervention",
    label: "Intervention",
    type: "select",
    placeholder: "Sélectionnez un type",
    options: interventionsOptions,
    required: true,
  },
  {
    name: "typeIntervention",
    label: "Type d'intervention",
    type: "text",
    icon: faWrench,
    required: true,
  },
  {
    name: 'statutCT',
    label: 'Statut CT',
    type: 'select',
    required: true,
    options: Object.values(StatutCT).map((statut) => ({ value: statut, label: statut })),
    placeholder: 'Choisissez un statut',
  },
  {
    name: 'kilometrage',
    label: 'Kilométrage',
    type: 'text',
    required: true,
    placeholder: 'Relevé du kilométrage le plus récent',
    icon: faTachometerAlt,
  },
  {
    name: 'observation',
    label: 'Observation',
    type: 'textarea',
    placeholder: 'Anomalies ou remarques signalées',
    icon: faNoteSticky,
    rows: 2,
  },
  {
    name: 'dateCT',
    label: 'Date CT',
    type: 'date',
    required: true,
    icon: faCalendarDay,
  },
  {
    name: 'copieCT',
    label: 'Copie CT',
    type: 'file',
    accept: '.pdf,.jpg,.jpeg,.png',
    placeholder: 'Rapport de CT au format PDF ou image',
    icon: faFileAlt,
  },
  {
    name: 'idfFlotteVehicule',
    label: 'IDF Flotte Véhicule',
    type: 'text',
    required: true,
    placeholder: 'Identifiant interne du véhicule dans la flotte',
    icon: faHashtag,
  },
]; 