import * as yup from 'yup';
import { StatutCT, UserType } from '@/shared/types/flottes/revision';

export const revisionSchema = yup.object().shape({
  immatriculation: yup.string().required('L\'immatriculation est requise'),
  type: yup.string()
    .oneOf(Object.values(UserType), 'Type d\'utilisateur invalide')
    .required('Le type d\'utilisateur est requis'),
  personne: yup.string().required('La personne responsable est requise'),
  dateRevision: yup.date().required('La date de révision est requise'),
  garageRevision: yup.string().required('Le garage de révision est requis'),
  adresse: yup.string().required('L\'adresse est requise'),
  revisions: yup.string().required('La description des révisions est requise'),
  statutCT: yup.string()
    .oneOf(Object.values(StatutCT), 'Statut CT invalide')
    .required('Le statut CT est requis'),
  kilometrage: yup.string().required('Le kilométrage est requis'),
  observation: yup.string(),
  dateCT: yup.date().required('La date du CT est requise'),
  copieCT: yup.string(),
  idfFlotteVehicule: yup.string().required('L\'identifiant du véhicule est requis'),
}); 