'use client';
import React from 'react';
import { Typography, Box, Link } from '@mui/material';

const fileTemplates = [
  { name: 'Carburant DKV', url: '/files/Carburant DKV.xls' },
  { name: 'Carburant Total', url: '/files/Carburant Total.xls' },
];

const FileTemplatesList: React.FC = () => {
  return (
    <Box mt={4} px={2}>
      <Typography
        mb={1}
        sx={{
          textDecoration: 'none',
          color: 'text.primary',
          fontSize: '16px',
        }}
      >
        Templates des fichiers :
      </Typography>

      {fileTemplates.map((file) => (
        <Box
          key={file.url}
          sx={{
            display: 'flex',
            alignItems: 'center',
            py: 0.5,
            px: 1,
            borderRadius: 1,
            transition: 'background-color 0.2s, transform 0.1s',
            '&:hover': {
              backgroundColor: 'action.hover',
              transform: 'scale(1.01)',
            },
          }}
        >
          <Link
            href={file.url}
            component="a"
            download
            sx={{
              textDecoration: 'none',
              color: 'text.secondary',
              fontSize: '14px',
              width: '100%',
              '&:hover': {
                color: 'primary.main',
              },
            }}
          >
            - {file.name}
          </Link>
        </Box>
      ))}
    </Box>
  );
};

export default FileTemplatesList;
