"use client"
import { type TabConfig, useTabsManager } from "@/hooks/use-tabs-manager"
import { IFuelCardImportHistory } from "@/shared/types/flottes/suiviCartes"
import { INITIAL_FUEL_CARD_IMPORT_HISTORY_DATA } from "@/shared/_mock/flottes/_suiviCartes"

const fuelCardImportHistoryConfig: TabConfig<IFuelCardImportHistory> = {
  type: "frais carburant",
  listTitle: "Liste des import de cartes carburant",
  newItemTitle: "Nouveau import de cartes carburant",
  initialData: INITIAL_FUEL_CARD_IMPORT_HISTORY_DATA,
  getItemCode: (fuelCardImport) => fuelCardImport.id,
}

export function useFuelCarsImportHistoryTabs() {
  return useTabsManager<IFuelCardImportHistory>(fuelCardImportHistoryConfig)
}
