"use client"

import { type TableConfig, useTableManager } from "@/hooks/use-table-manager"
import type { ISuiviCarte } from "@/shared/types/flottes/suiviCartes"
import { _suiviCartes, DEFAULT_SUIVI_CARTES_TABLE_HEAD } from "@/shared/_mock/flottes/_suiviCartes"

const suiviCartesConfig: TableConfig<ISuiviCarte> = {
  initialData: _suiviCartes,
  defaultTableHead: DEFAULT_SUIVI_CARTES_TABLE_HEAD,
}

export function useSuiviCartesTable() {
  return useTableManager<ISuiviCarte>(suiviCartesConfig)
} 