"use client"

import type { ISuiviCarte } from "@/shared/types/flottes/suiviCartes"
import { INITIAL_SUIVI_CARTE_DATA } from "@/shared/_mock/flottes/_suiviCartes"
import { type TabConfig, useTabsManager } from "@/hooks/use-tabs-manager"

const suiviCartesConfig: TabConfig<ISuiviCarte> = {
  type: "carte carburant",
  listTitle: "Suivi des cartes carburant",
  newItemTitle: "Nouvelle carte carburant",
  initialData: INITIAL_SUIVI_CARTE_DATA,
  getItemCode: (carte) => carte.numeroCarteCarburant,
}

export function useSuiviCartesTabs() {
  return useTabsManager<ISuiviCarte>(suiviCartesConfig)
} 