'use client';
import React from 'react';
import { Box, Stack } from '@mui/material';
import { HEADER } from '@/layouts/config-layout';
import TableControlBar from '@/shared/components/table/table-control-bar';
import { TableType } from '@/shared/types/common';
import CustomTabs from '@/shared/components/tabs/tabs-custom';
import TableManager from '@/shared/components/table/table-manager';
import { useFuelCarsImportHistoryTabs } from '../hooks/use-fuel-card-import-history-tabs';
import { useFuelCarsImportHistoryTable } from '../hooks/use-fuel-card-import-history-table';
import { IFuelCardImportHistory } from '@/shared/types/flottes/suiviCartes';
import FuelCardImportHistoryTableRow from './fuel-card-import-history-table-row';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';
import FuelCradImportHistoryDetail from './import-history-list-view';
import ImportSection from '../components/import-section';

export default function FuelCardImportHistoryListView() {
  const {
    tabs,
    activeTab,
    handleTabClose,
    handleTabChange,
    handleTabAdd,
    handleEdit,
    handleView,
    handleCancel,
    handleCopy,
    setTabHasUnsavedChanges,
    showConfirmDialog,
    setShowConfirmDialog,
    handleConfirmDialogAction,
    updateTabContent,
  } = useFuelCarsImportHistoryTabs();

  const {
    table,
    filteredData,
    filters,
    tableHead,
    notFound,
    handleFilterChange,
    handleResetFilters,
    handleResetColumns,
    handleColumnsChange,
    handleSave,
    dataToExport,
  } = useFuelCarsImportHistoryTable();

  const activeTabData = React.useMemo(() => {
    return tabs.find((tab) => tab.id === activeTab);
  }, [tabs, activeTab]);

  const handleRowDoubleClick = (row: IFuelCardImportHistory) => {
    handleView(row);
  };
  const renderRow = (row: IFuelCardImportHistory) => (
    <FuelCardImportHistoryTableRow
      key={row.id}
      row={row}
      handleCopyFuelFee={() => handleRowDoubleClick(row)}
      handleEditFuelFee={handleEdit}
      handleDetailsFuelFee={handleView}
      selected={table.selected.includes(row.id)}
      onSelectRow={() => table.onSelectRow(row.id)}
      columns={tableHead}
    />
  );

  return (
    <Box
      sx={{
        display: 'flex',
        flexDirection: 'column',
        height: `calc(100vh - ${HEADER.H_DESKTOP + 8}px)`,
      }}
    >
      <Stack
        flexGrow={0}
        direction="row"
        alignItems="center"
        justifyContent="flex-end"
        spacing={{ xs: 0.5, sm: 1 }}
      >
        <TableControlBar
          type={TableType.FuelFee}
          handleTabAdd={handleTabAdd}
          activeTab={activeTab}
          onResetFilters={handleResetFilters}
          onResetColumns={handleResetColumns}
          onColumnsChange={handleColumnsChange}
          initialColumns={tableHead.slice(0, -1)}
          onFilters={handleFilterChange}
          filteredData={dataToExport}
          buttonAddTitle="Nouveau import de cartes carburant"
        />
      </Stack>

      <CustomTabs
        type={TableType.FuelFee}
        tabs={tabs}
        activeTab={activeTab}
        handleTabChange={handleTabChange}
        handleTabClose={handleTabClose}
      />
      <ConditionalComponent
        isValid={activeTab === 'list'}
        defaultComponent={
          <ConditionalComponent
            isValid={activeTabData?.mode === 'add'}
            defaultComponent={<FuelCradImportHistoryDetail />}
          >
            <ImportSection />
          </ConditionalComponent>
        }
      >
        <TableManager
          filteredData={filteredData}
          table={table}
          tableHead={tableHead}
          notFound={notFound}
          filters={filters}
          onFilterChange={handleFilterChange}
          renderRow={renderRow}
        />
      </ConditionalComponent>
    </Box>
  );
}
