'use client';

import React from 'react';
import { Box, Stack, Typography } from '@mui/material';
import { HEADER } from '@/layouts/config-layout';
import TableControlBar from '@/shared/components/table/table-control-bar';
import { useSuiviCartesTabs } from '../hooks/use-suivi-cartes-tabs';
import { useSuiviCartesTable } from '../hooks/use-suivi-cartes-table';
import { TableType, TypeImport } from '@/shared/types/common';
import { ISuiviCarte } from '@/shared/types/flottes/suiviCartes';
import CustomTabs from '@/shared/components/tabs/tabs-custom';
import TableManager from '@/shared/components/table/table-manager';
import SuiviCartesTableRow from '../components/suivi-cartes-table-row';
import { UnsavedChangesDialog } from '@/shared/components/dialog/UnsavedChangesDialog';
import { pxToRem } from '@/shared/theme/typography';
import { ScrollBox } from '@/shared/theme/css';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';

export default function FuelCradImportHistoryDetail() {
  const {
    tabs,
    activeTab,
    handleTabClose,
    handleTabChange,
    handleTabAdd,
    handleEdit,
    handleView,
    handleCancel,
    handleCopy,
    setTabHasUnsavedChanges,
    showConfirmDialog,
    setShowConfirmDialog,
    handleConfirmDialogAction,
    updateTabContent,
  } = useSuiviCartesTabs();

  const {
    table,
    filteredData,
    filters,
    tableHead,
    notFound,
    handleFilterChange,
    handleResetFilters,
    handleResetColumns,
    handleColumnsChange,
    handleSave,
    handleStatusChange,
    dataToExport,
  } = useSuiviCartesTable();

  const renderRow = (row: ISuiviCarte) => (
    <SuiviCartesTableRow
      key={row.id}
      row={row}
      selected={table.selected.includes(row.id)}
      onSelectRow={() => table.onSelectRow(row.id)}
      columns={tableHead}
    />
  );

  return (
    <ScrollBox
      sx={{
        display: 'flex',
        flexDirection: 'column',
        height: `calc(100vh - ${HEADER.H_DESKTOP + 8}px)`,
        backgroundColor: 'background.default',
        p: 3,
      }}
    >
      <Box sx={{ flex: 1, display: 'flex', flexDirection: 'column' }}>
        <Box sx={{ mb: 3 }}>
          <Typography
            variant="h5"
            sx={{
              fontSize: pxToRem(24),
              color: 'primary.main',
              fontWeight: 600,
              mb: 1,
              display: 'flex',
              alignItems: 'center',
              gap: 1,
            }}
          >
            Historique Carte carburant
          </Typography>
        </Box>

        <Stack
          flexGrow={0}
          direction="row"
          alignItems="center"
          justifyContent="flex-end"
          spacing={{ xs: 0.5, sm: 1 }}
          sx={{ mb: 2 }}
        >
          <TableControlBar
            type={TableType.FuelHistory}
            activeTab={activeTab}
            onResetFilters={handleResetFilters}
            onResetColumns={handleResetColumns}
            onColumnsChange={handleColumnsChange}
            initialColumns={tableHead}
            onFilters={handleFilterChange}
            filteredData={dataToExport}
          />
        </Stack>

        <CustomTabs
          type={TableType.FuelHistory}
          tabs={tabs}
          activeTab={activeTab}
          handleTabChange={handleTabChange}
          handleTabClose={handleTabClose}
        />

        {/* Tableau principal */}
        <ConditionalComponent
          isValid={activeTab === 'list'}
          defaultComponent={
            <Box sx={{ p: 3 }}>
              <Typography>Form content here...</Typography>
            </Box>
          }
        >
          <TableManager
            filteredData={filteredData}
            table={table}
            tableHead={tableHead}
            notFound={notFound}
            filters={filters}
            onFilterChange={handleFilterChange}
            renderRow={renderRow}
            fixedHeight="calc(100vh - 480px)"
            sx={{
              backgroundColor: 'white',
              '& .MuiTableContainer-root': {
                borderRadius: 0,
              },
            }}
          />
        </ConditionalComponent>
      </Box>

      {/* Dialog de confirmation pour les modifications non sauvegardées */}
      <UnsavedChangesDialog
        open={showConfirmDialog}
        onClose={() => setShowConfirmDialog(false)}
        onConfirm={() => handleConfirmDialogAction()}
        onCancel={() => setShowConfirmDialog(false)}
      />
    </ScrollBox>
  );
}
