import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { DeclarationType, IncidentStatus, VehicleIncident, VehicleIncidentRequest } from '@/shared/types/fleet-management/vehicle-incident';
import { CoverageZone, InterventionType } from '@/shared/types/fleet-management/service-provider';

export const INITIAL_VEHICLE_INCIDENT_DATA: VehicleIncident = {
  id: '',
  departmentId: '',
  departmentName: '',
  incidentDate: '',
  vehicleId: '',
  vehicleRegistrationPlate: '',
  driverId: '',
  driverName: '',
  damages: '',
  circumstances: '',
  responsibility: '',
  declarationType: DeclarationType.AXA,
  serviceProvider: {
    id: '',
    name: '',
    coverageZone: CoverageZone.LOCAL,
    intervention: {
      id: '',
      name: '',
      interventionType: InterventionType.MAINTENANCE_AND_REVISION,
      customInterventionType: '',
    },
    amount: 0,
    active: true
  },
  cost: 0,
  status: IncidentStatus.IN_PROGRESS,
  active: true,
};


const vehicleIncidentConfig: TabConfig<VehicleIncident | VehicleIncidentRequest> = {
  type: 'sinistre',
  listTitle: 'incidents / Sinistre',
  newItemTitle: 'Nouveau Sinistre',
  initialData: INITIAL_VEHICLE_INCIDENT_DATA,
  getItemCode: (vehicleIncident) => vehicleIncident.id,
};

export function useVehicleIncidentTabs() {
  return useTabsManager<VehicleIncident | VehicleIncidentRequest>(vehicleIncidentConfig);
}