import type { FormFieldType } from "@/shared/types/common"
import {
  faEuro,
  faCarCrash,
  faInfoCircle,
  faUserShield,
} from "@fortawesome/free-solid-svg-icons"
import { DeclarationTypeOptions, VehicleIncidentRequest } from "@/shared/types/fleet-management/vehicle-incident";
import { InterventionTypeOptions } from "@/shared/types/fleet-management/service-provider";

export const mainIncidentFormFields = (
  departmentOptions: { value: string; label: string }[],
  vehicleOptions: { value: string; label: string }[],
  driverOptions: { value: string; label: string }[]
): FormFieldType<VehicleIncidentRequest>[] => [
    {
      name: "departmentId",
      label: "Département",
      type: "select",
      placeholder: "Sélectionnez le département",
      options: departmentOptions,
      required: true,
    },
    {
      name: "incidentDate",
      label: "Date de l'incident",
      type: "date",
      required: true,
    },
    {
      name: "vehicleId",
      label: "Véhicule",
      type: "select",
      options: vehicleOptions,
      placeholder: "Choisissez un véhicule",
      required: true,
    },
    {
      name: "driverId",
      label: "Conducteur",
      type: "select",
      options: driverOptions,
      placeholder: "Choisissez un conducteur",
      required: true,
    },
  ];

export const descriptionIncidentFormFields: FormFieldType<VehicleIncidentRequest>[] = [
  {
    name: "damages",
    label: "Dégâts",
    type: "text",
    placeholder: "Décrivez les dégâts",
    icon: faCarCrash,
  },
  {
    name: "circumstances",
    label: "Circonstances",
    type: "text",
    placeholder: "Décrivez les circonstances",
    icon: faInfoCircle,
  },
  {
    name: "responsibility",
    label: "Responsabilité",
    type: "text",
    placeholder: "Saisissez la responsabilité",
    icon: faUserShield,
  },
];

export const suiviAdminIncidentFormFields = (
  serviceProviderOptions: { value: string; label: string }[],
  interventionOptions: { value: string; label: string }[]
): FormFieldType<VehicleIncidentRequest>[] => [
    {
      name: "declarationType",
      label: "Déclaration",
      type: "select",
      options: DeclarationTypeOptions,
      placeholder: "Choisissez le type de déclaration",
      required: true,
    },
    {
      name: "serviceProviderId",
      label: "Fournisseur",
      type: "select",
      placeholder: "Nom du fournisseur",
      options: serviceProviderOptions,
      required: true,
    },
    {
      name: "interventionId",
      label: "Intervention",
      type: "select",
      required: true,
      options: interventionOptions
    },
    {
      name: "interventionType",
      label: "Type d'intervention",
      type: "select",
      required: true,
      placeholder: "Sélectionnez le type d'intervention",
      options: InterventionTypeOptions,
    },
    {
      name: "cost",
      label: "Montant",
      type: "number",
      placeholder: "Entrez le montant",
      icon: faEuro,
      required: true
    },
  ];