import { type IIncident } from "@/shared/types/flottes/incident"
import { InterventionTab, type IIntervention } from "@/shared/types/flottes/intervention"
import { IRevision, StatutCT, UserType } from "@/shared/types/flottes/revision"
import { InterventionType } from "@/shared/types/flottes/vehicule"

export function convertIncidentToIntervention(incident: IIncident): IIntervention {
  return {
    id: '',
    departement: incident.department,
    vehiculeConcerne: incident.vehicle,
    immatriculation: "",
    intervention: incident.intervention || "",
    typeIntervention: incident.interventionType || "",
    dateIntervention: incident.date,
    fournisseur: incident.supplier || "",
    montantDevis: incident.amount?.toString() || "0",
    statut: InterventionTab.EnAttente,
    kilometrageReleve: "",
    coutTTC: "",
    coutHT: "",
    acceptationDevis: "",
    observations: incident.circumstances || incident.damages || "",
    dateDebutImmobilisation: "",
    dateFinImmobilisation: "",
    reparateur: "",
    factureRecue: "",
    conducteurPrevenu: "",
    garage: "",
    dateFacture: "",
    numeroFacture: "",
    pieces: "",
    quantitePieces: 0,
    isActive: incident.isActive,
  }
}


export function convertIncidentToRevision(incident: IIncident): IRevision {
  return {
    id: "",
    immatriculation: incident.vehicle,
    personne: incident.driver,
    dateRevision: incident.date,
    garageRevision: "",
    supplier: incident.supplier || "",
    typeIntervention: incident.interventionType as InterventionType || InterventionType.Entretien,
    intervention: incident.intervention || "",
    observation: "",
    derniereMiseAJour: new Date().toISOString(),
    isActive: incident.isActive,
    type: UserType.CHAUFFEUR,
    adresse: "",
    statutCT: StatutCT.EN_COURS,
    kilometrage: "",
    dateCT: "",
    copieCT: "",
    idfFlotteVehicule: "",
  }
}