import * as yup from "yup";

export const vehicleIncidentSchema = yup.object().shape({
  departmentId: yup
    .string()
    .required("Le département est obligatoire"),

  incidentDate: yup
    .date()
    .typeError("Veuillez sélectionner une date valide")
    .required("La date de l'incident est obligatoire")
    .max(new Date(), "La date de l'incident ne peut pas être dans le futur"),

  vehicleId: yup
    .string()
    .required("Le véhicule est obligatoire"),

  driverId: yup
    .string()
    .required("Le conducteur est obligatoire"),

  damages: yup
    .string()
    .nullable()
    .max(500, "La description des dégâts ne doit pas dépasser 500 caractères"),

  circumstances: yup
    .string()
    .nullable()
    .max(1000, "Les circonstances ne doivent pas dépasser 1000 caractères"),

  responsibility: yup
    .string()
    .nullable()
    .max(255, "La responsabilité ne doit pas dépasser 255 caractères"),

  declarationType: yup
    .string()
    .required("Le type de déclaration est obligatoire"),

  serviceProviderId: yup
    .string()
    .required("Le fournisseur est obligatoire"),

  interventionId: yup
    .string()
    .required("L’intervention est obligatoire"),

  interventionType: yup
    .string()
    .required("Le type d’intervention est obligatoire"),

  cost: yup
    .number()
    .typeError("Le montant doit être un nombre")
    .min(0, "Le montant ne peut pas être négatif")
    .required("Le montant est obligatoire"),
});