import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { VehicleListResponse, VehicleRequest, VehicleStatus } from '@/shared/types/fleet-management/vehicle';

const INITIAL_VEHICLE_DATA: VehicleListResponse = {
  id: "",
  vehicleIdentificationNumber: "",
  status: VehicleStatus.ACTIVE,
  registrationPlate: "",
  driverName: "",
  brandName: "",
  modelName: "",
  departmentName: "",
  fuelTypeName: "",
  vehicleTypeName: "",
  active: true,
}

const vehicleConfig: TabConfig<VehicleListResponse | VehicleRequest> = {
  type: 'véhicule',
  listTitle: 'Liste des véhicules',
  newItemTitle: 'Nouveau véhicule',
  initialData: INITIAL_VEHICLE_DATA,
  getItemCode: (vehicle) => vehicle.vehicleIdentificationNumber,
};

export function useVehicleTabs() {
  return useTabsManager<VehicleListResponse | VehicleRequest>(vehicleConfig);
}