import { _MARQUES, _MODELES } from "@/shared/_mock"
import { _CHAUFFEURS } from "@/shared/_mock/_absenceDriver"
import { DEPARTEMENT_OPTIONS } from "@/shared/sections/establishment/attendance/utils/form-fields-attendance"
import { FormFieldType } from "@/shared/types/common"
import { IVehicle } from "@/shared/types/flottes/vehicule"
import {
  faHashtag,
  faMagnifyingGlassLocation,
  faNoteSticky,
  faTag,
  faGasPump,
  faCalendar,
  faClock,
  faUser,
  faMoneyBill,
  faMapMarkerAlt,
  faIdCard,
} from "@fortawesome/free-solid-svg-icons"
import { _suppliers } from "@/shared/_mock/flottes/_supplier"
import { VehicleRequest } from "@/shared/types/fleet-management/vehicle"

export const _VEHICLE_DOCUMENT_TYPES = [
  { value: 'carte_grise', label: "Carte grise : Certificat d'immatriculation" },
  { value: 'assurance', label: 'Assurance : Police d\'assurance en cours' },
  { value: 'controle_technique', label: 'Contrôle technique : Certificat de contrôle technique' },
  { value: 'permis_circulation', label: 'Permis de circulation : Autorisation de circuler' },
  { value: 'facture', label: "Facture d'achat/location : Documents financiers" },
  { value: 'contrat_location', label: 'Contrat de location : Contrat avec le loueur' },
  { value: 'expertise', label: 'Expertise : Rapports d\'expertise' },
  { value: 'maintenance', label: "Maintenance : Carnets d'entretien" },
  { value: 'autres', label: 'Autres documents : Documents divers' },
];

export const vehicleformFields = (
  vehicleTypeOptions: { value: string; label: string }[],
  brandNameOptions: { value: string; label: string }[],
  modelNameOptions: { value: string; label: string }[],
  driverOptions: { value: string; label: string }[],
  departmentOptions: { value: string; label: string }[],
  fuelTypeOptions: { value: string; label: string }[],
  sectorOptions: { value: string; label: string }[],
): FormFieldType<VehicleRequest>[] => [
    {
      name: 'vehicleIdentificationNumber',
      label: 'Numéro de chassis',
      type: 'text',
      placeholder: 'AAAA0000000000000',
      icon: faTag,
      required: true
    },
    {
      name: 'registrationPlate',
      label: 'Immatriculation',
      type: 'text',
      placeholder: 'AAAA 0000 000 0000',
      icon: faTag,
      required: true
    },
    {
      name: 'brandName',
      label: 'Marque',
      type: 'select',
      options: brandNameOptions,
      placeholder: 'Choisissez une marque',
      required: true
    },
    {
      name: 'modelName',
      label: 'Modèle',
      type: 'select',
      options: modelNameOptions,
      placeholder: 'Choisissez un modèle',
      required: true
    },
    {
      name: 'driverId',
      label: 'Chauffeur',
      type: 'select',
      options: driverOptions,
      placeholder: "Choisissez un chauffeur",
      required: true
    },
    {
      name: 'vehicleTypeId',
      label: 'Type de véhicule',
      type: 'select',
      options: vehicleTypeOptions,
      placeholder: 'Choisissez un type',
      required: true
    },
    {
      name: "registrationDate",
      label: "Date immatriculation",
      type: "date",
      required: true
    },
    {
      name: 'departmentId',
      label: 'Département',
      type: 'select',
      options: departmentOptions,
      placeholder: 'Choisissez un Département',
      required: true
    },
    {
      name: 'seatCount',
      label: 'Nombre de places',
      type: 'text',
      icon: faHashtag,
      placeholder: '000',
      required: true
    },
    {
      name: 'fuelTypeId',
      label: 'Type de carburant',
      type: 'select',
      options: fuelTypeOptions,
      required: true
    },
    {
      name: 'wheelchairSeatCount',
      label: 'Places fauteuil roulant',
      type: 'text',
      icon: faHashtag,
      placeholder: '000',
    },
    {
      name: 'geolocationCode',
      label: 'Code géolocalisation',
      type: 'text',
      placeholder: '0000 0000 000 0000',
      icon: faMagnifyingGlassLocation
    },
    {
      name: "observation",
      label: "Observation",
      type: "textarea",
      placeholder: "Ajoutez une note ou une observation",
      icon: faNoteSticky,
    },
    // Informations de location
    {
      name: 'locationContractCode',
      label: 'Code contrat location',
      type: 'text',
      placeholder: '0000 000 0000',
      icon: faHashtag,
      required: true
    },
    {
      name: 'orderDate',
      label: 'Date de commande',
      type: 'date',
      icon: faCalendar,
      required: true
    },
    {
      name: 'deliveryDate',
      label: 'Date de livraison',
      type: 'date',
      icon: faCalendar,
      required: true
    },
    {
      name: 'locationPeriod',
      label: 'Durée de location (mois)',
      type: 'number',
      icon: faClock,
      placeholder: '12',
      required: true
    },
    {
      name: 'proprietor',
      label: 'Propriétaire',
      type: 'text',
      icon: faUser,
      placeholder: 'Nom du propriétaire légal',
      required: true
    },
    {
      name: 'locationTariff',
      label: 'Tarif location (€)',
      type: 'number',
      icon: faMoneyBill,
      placeholder: '0.00',
      required: true
    },
    {
      name: 'sectorId',
      label: 'Secteur',
      type: 'select',
      options: sectorOptions,
      icon: faMapMarkerAlt,
      placeholder: 'Choisissez un secteur',
      required: true
    },
    {
      name: 'licenceNumber',
      label: 'Numéro de licence',
      type: 'text',
      icon: faIdCard,
      placeholder: 'Numéro de licence d\'exploitation',
      required: true
    },
  ]