import * as yup from 'yup'

export const vehicleSchema = yup.object().shape({
  vehicleIdentificationNumber: yup.string().required('Numéro de chassis est requis'),
  registrationPlate: yup.string().required('L\'immatriculation est requise'),
  brandName: yup.string().required('La marque est requise'),
  modelName: yup.string().required('Le modèle est requis'),
  vehicleTypeId: yup.string().required('Le type de véhicule est requis'),
  registrationDate: yup.date().required('La date d\'immatriculation est requise'),
  departmentId: yup.string().required('Le département est requis'),
  driverId: yup.string().required('Le chauffeur est requis'),
  seatCount: yup.number().required('Le nombre de places est requis'),
  fuelTypeId: yup.string().required('Le type de carburant est requis'),
  wheelchairSeatCount: yup.number(),
  geolocationCode: yup.string(),
  observation: yup.string(),
  // Informations de location
  locationContractCode: yup.string().required('L\'ID du contrat est requis'),
  orderDate: yup.date().required('La date de commande est requise'),
  deliveryDate: yup.date().required('La date de livraison est requise'),
  locationPeriod: yup.number().min(1, 'La durée doit être d\'au moins 1 mois').required('La durée de location est requise'),
  proprietor: yup.string().required('Le propriétaire est requis'),
  locationTariff: yup.number().min(0, 'Le tarif doit être positif').required('Le tarif de location est requis'),
  sectorId: yup.string().required('Le secteur est requis'),
  licenceNumber: yup.string().required('Le numéro de licence est requis'),
})