import { type TabConfig, useTabsManager } from "@/hooks/use-tabs-manager"
import { VehicleBrandModel, VehicleBrandModelRequest } from "@/shared/types/fleet-management/vehicle-brand-model"

export const INITIAL_VEHICLE_BRAND_MODEL_DATA: VehicleBrandModel = {
  id: "",
  brandName: "",
  modelName: "",
  generalMaintenanceDate: "",
  observation: "",
  vehicleType: {
    id: "",
    name: "",
    observation: "",
    active: false
  },
  active: false
}

const vehicleBrandModelConfig: TabConfig<VehicleBrandModel | VehicleBrandModelRequest> = {
  type: "marque / modèle de véhicule",
  listTitle: "Liste des marques / modèles",
  newItemTitle: "Nouveau marque / modèle",
  initialData: INITIAL_VEHICLE_BRAND_MODEL_DATA,
  getItemCode: (vehicleModel) => `${vehicleModel.brandName} ${vehicleModel.modelName}`,
}

export function useVehicleBrandModelTabs() {
  return useTabsManager<VehicleBrandModel | VehicleBrandModelRequest>(vehicleBrandModelConfig)
}