import type { FormFieldType } from "@/shared/types/common"
import { VehicleBrandModelRequest } from "@/shared/types/fleet-management/vehicle-brand-model";
import { faNoteSticky, faCalendarCheck } from "@fortawesome/free-solid-svg-icons"

export const vehicleBrandModelFormFields = 
(vehicleTypeOptions: { value: string; label: string }[]): FormFieldType<VehicleBrandModelRequest>[] => [
  {
    name: "brandName",
    label: "Marque",
    type: "text",
    required: true,
    placeholder: "Saisissez une marque",
  },
  {
    name: "modelName",
    label: "Modèle",
    type: "text",
    required: true,
    placeholder: "Saisissez un modèle",
  },
  {
    name: "vehicleType",
    label: "Type de véhicule",
    type: "select",
    placeholder: "Choisissez un type de véhicule",
    options: vehicleTypeOptions
  },
  {
    name: "generalMaintenanceDate",
    label: "Date d'entretien générales",
    type: "date",
    icon: faCalendarCheck,
  },
  {
    name: "observation",
    label: "Observation",
    type: "textarea",
    placeholder: "Ajoutez une note ou une observation",
    icon: faNoteSticky
  },
]