import TableCell from '@mui/material/TableCell';
import TableActionColumn from '@/shared/components/table/table-action-column';
import type { TableColumn } from '@/shared/types/common';
import { TrajetStyledRow } from '@/shared/sections/contract/styles';
import { Intervention, InterventionType, InterventionTypeLabels } from '@/shared/types/fleet-management/service-provider';

interface Props {
  row: Intervention;
  columns: TableColumn[];
  handleEditIntervention: (intervention: Intervention) => void;
  handleDetailsIntervention: (intervention: Intervention) => void;
}

const TOOLTIP_TITLES = {
  edit: "Modifier l'intervention",
  duplicate: "Ajouter au même type",
};

export default function InterventionRowView({ row, columns, handleEditIntervention, handleDetailsIntervention }: Props) {

    const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      case "interventionType":
        return InterventionTypeLabels[value as InterventionType]
      default:
        return value;
    }
  };

  return (
    <TrajetStyledRow style={{ cursor: 'pointer' }}>
      {columns.filter((c) => c.id !== 'action').map((column) => (
        <TableCell
          onDoubleClick={() => handleDetailsIntervention(row)}
          key={column.id}
          align={column.align}
          sx={{ whiteSpace: 'nowrap' }}
        >
          {renderCellContent(column.id, row[column.id as keyof Intervention])}
        </TableCell>
      ))}
      <TableCell align="right" sx={{ px: 1, whiteSpace: 'nowrap' }}>
        <TableActionColumn
          handleEdit={() => handleEditIntervention(row)}
          tooltipTitles={TOOLTIP_TITLES}
        />
      </TableCell>
    </TrajetStyledRow>
  );
}