import { type TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { Intervention, InterventionType } from '@/shared/types/fleet-management/service-provider';

export const INITIAL_INTERVENTION_DATA: Intervention = {
  id: "",
  name: "",
  interventionType: InterventionType.MAINTENANCE_AND_REVISION,
  customInterventionType: ""
}

const interventionTabConfig: TabConfig<Intervention> = {
  type: 'intervention',
  listTitle: 'Liste des interventions',
  newItemTitle: 'Nouvelle intervention',
  initialData: INITIAL_INTERVENTION_DATA,
  getItemCode: (intervention) => intervention.name,
};

export function useInterventionTabs() {
  return useTabsManager<Intervention>(interventionTabConfig);
}