import { type TabConfig, useTabsManager } from "@/hooks/use-tabs-manager"
import { INITIAL_SUPPLIER_DATA } from "@/shared/_mock/flottes/_supplier"
import { CoverageZone, InterventionType, ServiceProvider, ServiceProviderRequest } from "@/shared/types/fleet-management/service-provider";


export const INITIAL_SERVICE_PROVIDER_DATA: ServiceProviderRequest = {
  id: '',
  name: '',
  coverageZone: CoverageZone.NATIONAL,
  interventionId: '',
  interventionType: InterventionType.MAINTENANCE_AND_REVISION,
  amount: 0,
};

const serviceProviderConfig: TabConfig<ServiceProvider | ServiceProviderRequest> = {
  type: "fournisseur",
  listTitle: "Liste des fournisseurs",
  newItemTitle: "Nouveau fournisseur",
  initialData: INITIAL_SERVICE_PROVIDER_DATA,
  getItemCode: (serviceProvider) => serviceProvider.name,
}

export function useServiceProviderTabs() {
  return useTabsManager<ServiceProvider | ServiceProviderRequest>(serviceProviderConfig)
}