import type { FormFieldType } from "@/shared/types/common";
import { faBuilding, faGlobe, faWrench, faTag, faEuroSign } from "@fortawesome/free-solid-svg-icons";
import { CoverageZone, Intervention, InterventionType, InterventionTypeOptions, ServiceProviderRequest } from "@/shared/types/fleet-management/service-provider";


export const ServiceProviderFormFields = (interventionsOptions: {label: string, value: string}[]): FormFieldType<ServiceProviderRequest>[] => [
  {
    name: "name",
    label: "Nom du fournisseur",
    type: "text",
    required: true,
    placeholder: "Entrez le nom du fournisseur",
    icon: faBuilding
  },
  {
    name: "coverageZone",
    label: "Zone de couverture",
    type: "select",
    required: true,
    placeholder: "National ou Local",
    icon: faGlobe,
    options: [
      { value: CoverageZone.NATIONAL, label: 'National' },
      { value: CoverageZone.LOCAL, label: 'Local' },
    ]
  },
  {
    name: "interventionId",
    label: "Intervention",
    type: "select",
    required: true,
    options: interventionsOptions  
  },
  {
    name: "interventionType",
    label: "Type d'intervention",
    type: "select",
    required: true,
    placeholder: "Ex: Réparation, Révision...",
    icon: faWrench,
    options: InterventionTypeOptions,
    disabled: true
  },
  {
    name: "amount",
    label: "Prix",
    type: "number",
    required: true,
    placeholder: "Montant en €",
    icon: faEuroSign
  }
];

export const interventionFormFields: FormFieldType<Intervention>[] = [
  {
    name: 'name',
    label: "Nom de l'intervention",
    type: 'text',
    required: true,
    placeholder: "Ex: Vidange, Changement de pneus...",
    icon: faTag,
  },
  {
    name: 'interventionType',
    label: "Type d'intervention",
    type: 'select',
    required: true,
    placeholder: "Sélectionnez le type d'intervention",
    icon: faWrench,
    options: [
      { value: InterventionType.MAINTENANCE_AND_REVISION, label: 'Révision et entretien' },
      { value: InterventionType.REPAIR, label: 'Réparation' },
      { value: InterventionType.OTHER, label: 'Autre' },
    ],
  },
  {
    name: 'customInterventionType',
    label: "Autre type d'intervention",
    type: 'text',
    required: false,
    placeholder: "Précisez le type d'intervention",
    icon: faWrench,
  },
];