import * as yup from 'yup';

export const serviceProviderSchema = yup.object().shape({
  name: yup.string().required('Le nom du fournisseur est requis'),
  coverageZone: yup.string().required('La zone de couverture est requise'),
  interventionType: yup.string().required('Le type d\'intervention est requis'),
  interventionId: yup.string().required('L\'intervention est requise'),
  amount: yup.number().required('Le prix est requis'),
});

export const interventionSchema = yup.object().shape({
  name: yup.string().required('Le nom de l\'intervention est requis'),
  interventionType: yup.string().required('Le type d\'intervention est requis'),
  customInterventionType: yup.string().nullable().optional()
});