import { type TabConfig, useTabsManager } from "@/hooks/use-tabs-manager"
import { VehicleType } from "@/shared/types/fleet-management/vehicleType"

export const INITIAL_VEHICLE_TYPE_DATA: VehicleType = {
  id: "",
  name: "",
  observation: "",
  active: true,
}

const vehicleTypeConfig: TabConfig<VehicleType> = {
  type: "type de véhicule",
  listTitle: "Liste des types de véhicules",
  newItemTitle: "Nouveau type de véhicule",
  initialData: INITIAL_VEHICLE_TYPE_DATA,
  getItemCode: (vehicleType) => vehicleType.name,
}

export function useVehicleTypeTabs() {
  return useTabsManager<VehicleType>(vehicleTypeConfig)
}