import { Popover, Box, Typography } from '@mui/material';
import FontAwesome from '@/shared/components/fontawesome';
import {
  faCar,
  faCalendarCheck,
  faGasPump,
  faRoad,
  faWrench,
  faMagnifyingGlass,
} from '@fortawesome/free-solid-svg-icons';
import { pxToRem } from '@/shared/theme/typography';

interface VehicleDetail {
  icon: any;
  label: string;
  value: string;
}

interface VehicleDetailsPopoverProps {
  anchorEl: HTMLElement | null;
  vehicle: any;
  onClose: () => void;
}

export const VehicleDetailsPopover = ({ anchorEl, vehicle, onClose }: VehicleDetailsPopoverProps) => {
  const vehicleDetails: VehicleDetail[] = [
    { icon: faCar, label: "Type", value: vehicle?.type || "N/A" },
    { icon: faCalendarCheck, label: "Date de mise en service", value: "01/01/2024" },
    { icon: faGasPump, label: "Type de carburant", value: "Diesel" },
    { icon: faRoad, label: "Kilométrage", value: "45,000 km" },
    { icon: faWrench, label: "Dernière maintenance", value: "15/03/2024" },
    { icon: faMagnifyingGlass, label: "Observation", value: "Véhicule en bon état" },
  ];

  return (
    <Popover
      sx={{
        pointerEvents: 'none',
        '.MuiPopover-paper': {
          borderRadius: 4,
          border: (theme) => `2px solid ${theme.palette.primary.main}`,
        },
      }}
      open={Boolean(anchorEl)}
      anchorEl={anchorEl}
      anchorOrigin={{
        vertical: 'center',
        horizontal: 'right',
      }}
      transformOrigin={{
        vertical: 'top',
        horizontal: 'left',
      }}
      onClose={onClose}
      disableRestoreFocus
    >
      {vehicle ? (
        <Box sx={{ p: 1, maxWidth: 400 }}>
          <Box
            sx={{ display: 'grid', gridTemplateColumns: 'auto 1fr', gap: '6px', alignItems: 'center' }}
          >
            <Box
              sx={{
                mr: 1,
                width: 28,
                height: 28,
                borderRadius: '50%',
                bgcolor: 'primary.main',
                display: 'flex',
                alignItems: 'center',
                justifyContent: 'center',
              }}
            >
              <FontAwesome icon={faCar} color="white" width={14} />
            </Box>

            <Box sx={{ display: 'flex', flexDirection: 'column', justifyContent: 'center' }}>
              <Typography sx={{ fontSize: pxToRem(11) }} fontWeight={600} color="primary.main">
                Immatriculation
              </Typography>
              <Typography sx={{ fontSize: pxToRem(11) }}>{vehicle.registration || "N/A"}</Typography>
            </Box>

            {vehicleDetails.map((detail, index) => (
              <Box key={index} sx={{ gridColumn: 'span 2', display: 'grid', gridTemplateColumns: 'auto 1fr', gap: '6px', alignItems: 'center' }}>
                <Box
                  sx={{ mr: 1, display: 'flex', justifyContent: 'center', alignItems: 'center' }}
                >
                  <FontAwesome icon={detail.icon} color="primary.main" width={14} />
                </Box>

                <Box
                  sx={{ display: 'flex', flexDirection: 'column', justifyContent: 'center' }}
                >
                  <Typography sx={{ fontSize: pxToRem(11) }} fontWeight={600} color="primary.main">
                    {detail.label}
                  </Typography>
                  <Typography sx={{ fontSize: pxToRem(11) }}>{detail.value}</Typography>
                </Box>
              </Box>
            ))}
          </Box>
        </Box>
      ) : <></>}
    </Popover>
  );
};
