export type InterventionType = 'preventive' | 'corrective';
export type InterventionStatus = 'planifie' | 'en_cours' | 'termine';

export interface Vehicle {
  id: string;
  immatriculation: string;
  marque: string;
  modele: string;
  name: string;
  type: string;
  registration: string;
  driver: string;
  chauffeur?: string;
}

export interface TimeSlot {
  id: string;
  vehicleId: string;
  start: string;
  startHeure: string;
  startMinute: string;
  endHeure: string;
  endMinute: string;
  color: string;
  driverId: string;
  title: string;
  type: string;
  status: string;
  interventionDetails: any;
  technician: string;
  vehicle: Vehicle;
  estimatedDuration?: number;
}

export interface PlanningEvent {
  id: string;
  type: InterventionType;
  vehicle: Vehicle;
  status: InterventionStatus;
  startDate: string;
  endDate: string;
  estimatedDuration?: number; // in minutes
  description?: string;
  title: string;
}

export interface ScheduleData {
  vehicles: Vehicle[];
  timeSlots: TimeSlot[];
}

export interface DroppableCellProps {
  vehicleId: string;
  children: React.ReactNode;
  height: string;
}

export interface HeaderCellProps {
  theme?: any;
}

export const INTERVENTION_TYPES = {
  PREVENTIVE: 'preventive' as InterventionType,
  CORRECTIVE: 'corrective' as InterventionType,
};

export const INTERVENTION_STATUS = {
  PLANNED: 'planifie' as InterventionStatus,
  IN_PROGRESS: 'en_cours' as InterventionStatus,
  COMPLETED: 'termine' as InterventionStatus,
}; 

export type CurrentTimeSlot = {
  date: string;
  startHour: string;
  startMinute: string;
};