import { ModeType } from "@/shared/types/common";
import { CalendarEvent } from "./calendar-types";

export interface EventDetailsDialogProps {
  open: boolean;
  onClose: () => void;
  event: CalendarEvent;
  onEventUpdate: (updatedEvent: CalendarEvent) => void;
}

export type EventStatus = 'pending' | 'toRenew' | 'expired' | 'renewed';

export type EventDetailFieldName = 'date' | 'time' | 'employeeName' | 'location' | 'type' | 'status' | 'description' | 'files' | 'comments';

export interface EventDetailField {
  name: EventDetailFieldName;
  label: string;
  type: 'date' | 'time' | 'text' | 'select' | 'textarea';
  icon: any;
  hasCustomRender?: boolean;
}

export interface StatusConfigType {
  label: string;
  color: string;
}

export interface StatusOptionType {
  value: EventStatus;
  label: string;
  color: string;
}

export interface FormFieldItem {
  name: string;
  label: string;
  type: string;
  icon: any;
  value: any;
  render?: () => JSX.Element;
} 