import { 
  faCalendar, 
  faClock, 
  faUser, 
  faLocationDot, 
  faInfoCircle, 
  faCircleExclamation, 
  faFileLines, 
  faFile, 
  faComments 
} from '@fortawesome/free-solid-svg-icons';
import { FormField as IFormField } from '../types/calendar-types';

export const getFieldsForEmployeeType = (employeeType: 'DRIVER' | 'SEDENTARY'): IFormField[] => {
  const commonFields: IFormField[] = [
    {
      name: 'date',
      label: 'Date',
      type: 'text',
      icon: faCalendar,
    },
    {
      name: 'time',
      label: 'Horaire',
      type: 'time',
      icon: faClock,
    },
    {
      name: 'type',
      label: 'Type',
      type: 'select',
      icon: faInfoCircle,
      hasCustomRender: true
    },
    {
      name: 'status',
      label: 'Statut',
      type: 'select',
      icon: faCircleExclamation,
      hasCustomRender: true
    },
    {
      name: 'description',
      label: 'Description',
      type: 'textarea',
      icon: faFileLines,
      hasCustomRender: true
    },
    {
      name: 'files',
      label: 'Documents',
      type: 'text',
      icon: faFile,
    },
    {
      name: 'comments',
      label: 'Commentaires',
      type: 'textarea',
      icon: faComments,
      hasCustomRender: true
    }
  ];

  if (employeeType === 'DRIVER') {
    return [
      ...commonFields.slice(0, 2), 
      {
        name: 'employeeName',
        label: 'Chauffeur',
        type: 'text',
        icon: faUser,
      },
      ...commonFields.slice(2) 
    ];
  } else {
    return [
      ...commonFields.slice(0, 2),
      {
        name: 'agencyName',
        label: 'Agence',
        type: 'select',
        icon: faLocationDot,
        hasCustomRender: true
      },
      {
        name: 'employeeName',
        label: 'Agent',
        type: 'select',
        icon: faUser,
        hasCustomRender: true
      },
      ...commonFields.slice(2)
    ];
  }
};
