import { format } from 'date-fns';
import { fr } from 'date-fns/locale';
import { CalendarEvent, EventStatus, FormField as IFormField } from '../types/calendar-types';

export const getFieldValue = (field: IFormField, formData: CalendarEvent, status: EventStatus) => {
  switch (field.name) {
    case 'date':
      return format(new Date(formData.start), 'dd MMMM yyyy', { locale: fr });
    case 'time':
      return format(new Date(formData.start), 'HH:mm');
    case 'employeeName':
      return formData.employeeName || '';
    case 'agencyName':
      return formData.agence || 'Agence non spécifiée';
    case 'location':
      return formData.location || '';
    case 'type':
      return formData.type;
    case 'status':
      return status;
    case 'description':
      return formData.description || '';
    case 'files':
      return formData.files ? `${formData.files.length} document(s)` : 'Aucun document';
    case 'comments':
      return formData.comments || '';
    default:
      return '';
  }
};
