import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { IDemandeAbsence } from '@/shared/types/leave';

const INITIAL_CONGE_DATA: IDemandeAbsence = {
  id: '',
  requestNumber: '',
  submissionDate: new Date().toISOString().split('T')[0],
  requestType: 'Congé',
  leaveType: '',
  absenceType: '',
  startDate: '',
  endDate: '',
  status: 'En attente',
  processDate: '',
  reason: '',
  daysCount: 0,
  employeeId: '',
  employeeName: '',
  notificationMode: 'APPLICATION',
  isActive: true,
};

const congeConfig: TabConfig<IDemandeAbsence> = {
  type: 'conge',
  listTitle: 'Liste des congés',
  newItemTitle: 'Nouveau congé',
  initialData: INITIAL_CONGE_DATA,
  getItemCode: (conge: IDemandeAbsence) => `REQ-${conge.id || 'NEW'} - ${conge.leaveType}`,
};

export function useCongeTabs() {
  const tabManager = useTabsManager<IDemandeAbsence>(congeConfig);

  const handleApprove = async (conge: IDemandeAbsence) => {
    const updatedConge = {
      ...conge,
      status: 'Approuvée' as const,
      processDate: new Date().toISOString().split('T')[0],
    };
    return updatedConge;
  };

  const handleReject = async (conge: IDemandeAbsence) => {
    const updatedConge = {
      ...conge,
      status: 'Refusée' as const,
      processDate: new Date().toISOString().split('T')[0],
    };
    return updatedConge;
  };

  const handleViewHistory = (conge: IDemandeAbsence) => {
    // Implementation for viewing history
  };

  const handleDelete = async (conge: IDemandeAbsence) => {
    // Implementation for deleting if needed
  };

  return {
    ...tabManager,
    handleApprove,
    handleReject,
    handleViewHistory,
    handleDelete,
  };
}