import { FormFieldType } from '@/shared/types/common';
import { IDemandeAbsence, LeaveType } from '@/shared/types/leave';
import { 
  faUser, 
  faCalendarDays, 
  faFileLines, 
  faHashtag,
  faEnvelope 
} from '@fortawesome/free-solid-svg-icons';

// Constants for options - aligned with backend enum values
export const LEAVE_TYPES = [
  { value: 'LEAVE_SICK', label: 'Congé maladie' },
  { value: 'LEAVE_PARENTAL', label: 'Congé parental' },
  { value: 'LEAVE_PAID', label: 'Congé annuel' },
  { value: 'LEAVE_UNPAID', label: 'Congé sans solde' },
  { value: 'LEAVE_RTT', label: 'RTT' },
];

export const LEAVE_STATUS = [
  { value: 'En attente', label: 'En attente' },
  { value: 'Approuvée', label: 'Approuvée' },
  { value: 'Refusée', label: 'Refusée' },
];

export const LEAVE_DECISION = [
  { value: 'Validée', label: 'Validée' },
  { value: 'Refusée', label: 'Refusée' },
  { value: 'none', label: '' },
];

export const NOTIFICATION_MODES = [
  { value: 'SMS', label: 'SMS' },
  { value: 'EMAIL', label: 'Email' },
  { value: 'APPLICATION', label: 'Application' },
];

export const leaveFormFields: FormFieldType<IDemandeAbsence>[] = [
  {
    name: 'employeeId',
    label: "Nom de l'employé",
    type: 'select',
    required: true,
    icon: faUser,
    placeholder: "Sélectionner l'employé",
    options: [] // Options will be provided by the component
  },
  {
    name: 'leaveType',
    label: 'Type de congé',
    type: 'select',
    required: true,
    icon: faCalendarDays,
    placeholder: 'Sélectionner le type',
    options: LEAVE_TYPES
  },
  {
    name: 'reason',
    label: 'Motif (facultatif)',
    type: 'textarea',
    required: false,
    icon: faFileLines,
    placeholder: 'Entrez un motif'
  },
  {
    name: 'startDate',
    label: 'Date de début du congé',
    type: 'date',
    required: true,
    placeholder: 'YYYY-MM-DD'
  },
  {
    name: 'endDate',
    label: 'Date de fin du congé',
    type: 'date',
    required: true,
    placeholder: 'YYYY-MM-DD'
  },
  {
    name: 'daysCount',
    label: 'Nombre de jours demandés',
    type: 'number',
    required: true,
    icon: faHashtag,
    placeholder: '0',
    disabled: true // Auto-calculated from start/end dates
  },
  {
    name: 'notificationMode',
    label: 'Mode de notification',
    type: 'select',
    options: [
      { value: 'APPLICATION', label: 'Application' },
      { value: 'EMAIL', label: 'Email' },
      { value: 'SMS', label: 'SMS' },
      { value: 'PORTAL', label: 'Portail' }
    ],
    required: true,
  },
  {
    name: 'status',
    label: 'Statut',
    type: 'select',
    required: true,
    options: LEAVE_STATUS
  },
];

export const getStatusLabel = (status: string): string => {
  const statusObj = LEAVE_STATUS.find(s => s.value === status);
  return statusObj ? statusObj.label : status;
};

export const getDecisionLabel = (decision: string): string => {
  const decisionObj = LEAVE_DECISION.find(d => d.value === decision);
  return decisionObj ? decisionObj.label : decision;
};

export const getLeaveTypeLabel = (type: string): string => {
  const typeObj = LEAVE_TYPES.find(t => t.value === type);
  return typeObj ? typeObj.label : type;
};

export const getNotificationModeLabel = (mode: string): string => {
  const modeObj = NOTIFICATION_MODES.find(m => m.value === mode);
  return modeObj ? modeObj.label : mode;
};