import { Chip } from '@mui/material';
import { styled } from '@mui/system';

export const DocumentStatusChip = styled(Chip)(({ type }: { type: string }) => ({
  '&.MuiChip-root': {
    fontWeight: 500,
    borderRadius: '8px',
    padding: '9px 0',
    height: '100%',
    width: '100%',
    ...(type === 'contrat' && {
      backgroundColor: '#E9FBF0',
      color: '#36B37E',
    }),
    ...(type === 'attestation' && {
      backgroundColor: '#FEF8E7',
      color: '#F9B90B',
    }),
    ...(type === 'fiche de paie' && {
      backgroundColor: '#FFE1E1',
      color: '#FF3434',
    }),
    ...(type === 'autre' && {
      backgroundColor: '#F4F6F8',
      color: '#637381',
    }),
  },
}));

export const DocumentCategoryChip = styled(Chip)(({ category }: { category: string }) => ({
  '&.MuiChip-root': {
    fontWeight: 500,
    borderRadius: '8px',
    padding: '9px 0',
    height: '100%',
    width: '100%',
    ...(category === 'RH' && {
      backgroundColor: '#E9FBF0',
      color: '#36B37E',
    }),
    ...(category === 'PAIE' && {
      backgroundColor: '#FEF8E7',
      color: '#F9B90B',
    }),
  },
})); 