import React from 'react';
import { IFormulaire, FormulaireTab } from '@/shared/types/formulaire';
import TableManager from '@/shared/components/table/table-manager';
import FormulaireTableRow from '../views/formulaire-table-row';
import { TableColumn } from '@/shared/types/common';

interface FormulaireTableProps {
  filteredData: IFormulaire[];
  table: ReturnType<typeof import('@/shared/components/table/use-tablets').default>;
  tableHead: TableColumn[];
  notFound: boolean;
  filters: Record<string, { value: string; condition: string }>;
  onFilterChange: (key: string, value: string, condition: string) => void;
  handleEdit: (item: IFormulaire) => void;
  handleView: (item: IFormulaire) => void;
  handleDelete: (id: string) => void;
  activeTab: FormulaireTab;
}

export default function FormulaireTable({
  filteredData,
  table,
  tableHead,
  notFound,
  filters,
  onFilterChange,
  handleEdit,
  handleView,
  handleDelete,
  activeTab,
}: FormulaireTableProps) {
  const renderRow = (row: IFormulaire) => (
    <FormulaireTableRow
      dense={table.dense}
      key={row.id}
      row={row}
      handleEdit={handleEdit}
      handleView={handleView}
      handleDelete={handleDelete}
      selected={table.selected.includes(row.id)}
      onSelectRow={() => table.onSelectRow(row.id)}
      columns={tableHead.slice(0,-1)}
    />
  );

  return (
    <TableManager
      filteredData={filteredData}
      table={table}
      tableHead={tableHead}
      notFound={notFound}
      filters={filters}
      onFilterChange={onFilterChange}
      renderRow={renderRow}
    />
  );
} 