"use client"
import Checkbox from "@mui/material/Checkbox"
import TableCell from "@mui/material/TableCell"
import type { IFormulaire } from "@/shared/types/formulaire"
import { useTheme } from "@mui/material/styles"
import type { TableColumn } from "@/shared/types/common"
import { dateFormat, formatDate } from "@/utils/format-time"
import TableActionColumn from "@/shared/components/table/table-action-column"
import { faTrashCan } from "@fortawesome/free-solid-svg-icons"
import { IconButton } from "@mui/material"
import { ContratStyledRow } from "@/shared/sections/contract/styles"
import CustomTooltip from "@/shared/components/tooltips/tooltip-custom"
import { ActionsIconButton } from "@/shared/theme/css"
import FontAwesome from "@/shared/components/fontawesome"
import { CategoryMapping, StatusChip } from "../../styles"

type Props = {
  handleEdit: (formulaire: IFormulaire) => void
  handleView: (formulaire: IFormulaire) => void
  handleDelete: (id: string) => void
  selected: boolean
  row: IFormulaire
  onSelectRow: VoidFunction
  columns: TableColumn[]
  dense?: boolean
}

const TOOLTIP_TITLES = {
  edit: "Modifier formulaire",
  view: "Consulter formulaire",
  delete: "Supprimer formulaire",
}

export default function FormulaireTableRow({
  row,
  handleEdit,
  handleView,
  handleDelete,
  selected,
  onSelectRow,
  columns,
  dense = false,
}: Props) {
  const theme = useTheme()

  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      case "createdDate":
        return formatDate(value, dateFormat.isoDate)
      case "category":
        return (
          <StatusChip
            label={CategoryMapping[value as keyof typeof CategoryMapping] || value}
            size="small"
            status={value}
            color="primary"
            theme={theme}
            width="120px"
          />
        );
      default:
        return value
    }
  }

  return (
    <ContratStyledRow hover onDoubleClick={() => handleView(row)} style={{ cursor: "pointer" }}>
      
    {columns.map((column) => (
        <TableCell
          key={column.id}
          align={column.align || "left"}
          sx={{
            py: dense ? 1 : 2,
            whiteSpace: "nowrap",
          }}
        >
          {renderCellContent(column.id, row[column.id as keyof IFormulaire])}
        </TableCell>
      ))}

      <TableCell align="center" sx={{ display: "flex", px: 1, whiteSpace: "nowrap" }}>
        <TableActionColumn handleEdit={() => handleEdit(row)} tooltipTitles={TOOLTIP_TITLES} />
        <CustomTooltip title={TOOLTIP_TITLES.delete} arrow>
          <IconButton onClick={() => handleDelete(row.id)} size="small" sx={ActionsIconButton}>
            <FontAwesome icon={faTrashCan} width={14} />
          </IconButton>
        </CustomTooltip>
      </TableCell>
    </ContratStyledRow>
  )
}
