import { HEADER } from "@/layouts/config-layout";
import { alpha, Box, Button, Chip, Dialog, Rating, Stack, styled, SxProps, TableRow, Theme, ToggleButtonGroup } from "@mui/material";

export const AppointmentContainer = styled(Box)(({ theme }) => ({
  display: 'flex',
  flexDirection: 'column',
  height: `calc(100vh - ${HEADER.H_DESKTOP}px)`,
  padding: theme.spacing(2),
}));


export const DrawerStyles = {
  content: {
    p: 0,
  },
  title: {
    my: 3,
    color: 'primary.main',
    fontWeight: (theme: any) => theme.typography.fontWeightBold,
  },
};


export const StatusChip = styled(Chip)(({ status, theme }: { status: string; theme: any }) => ({
  '&.MuiChip-root': {
    fontWeight: 500,
    borderRadius: '8px',
    padding: '9px 0',
    height: '100%',
    width: '100%',
    ...(status === 'prevu' && {
      backgroundColor: alpha(theme.palette.primary.main, 0.1),
      color: theme.palette.primary.main,
    }),
    ...(status === 'annule' && {
      backgroundColor: '#FFE1E1',
      color: '#FF3434',
    }),
    ...(status === 'termine' && {
      backgroundColor: '#E9FBF0',
      color: '#36B37E',
    }),
    ...(status === 'en_attente' && {
      backgroundColor: '#FEF8E7',
      color: '#F9B90B',
    }),
  },
}));

export const CancelButton = styled(Button)(({ theme }) => ({
  backgroundColor: alpha(theme.palette.primary.main, 0.08),
  '&:hover': {
    backgroundColor: alpha(theme.palette.primary.main, 0.12),
  },
}));

export const ValidateButton = styled(Button)(({ theme }) => ({
  boxShadow: 'none',
  '&:hover': {
    boxShadow: 'none',
  },
}));

export const StyledToggleButtonGroup = styled(ToggleButtonGroup)(({ theme }) => ({
  borderRadius: '30px',
  padding: '4px',
  border: `2px solid ${theme.palette.primary.main}`,
  '& .MuiToggleButton-root': {
    border: 'none',
    borderRadius: '25px',
    padding: '8px 20px',
    marginRight: '4px',
    color: theme.palette.primary.main,
    fontSize: '0.875rem',
    fontWeight: 500,
    textTransform: 'none',
    backgroundColor: 'transparent',
    '&:last-of-type': {
      marginRight: 0,
    },
    '&:hover': {
      backgroundColor: alpha(theme.palette.primary.main, 0.08),
    },
    '&.Mui-selected': {
      backgroundColor: theme.palette.primary.main,
      color: theme.palette.primary.contrastText,
      boxShadow: '0 2px 4px rgba(0,0,0,0.1)',
      '&:hover': {
        backgroundColor: theme.palette.primary.dark,
      },
    },
  },
}));

export const AppointmentListStyles = {
  container: {
    display: 'flex',
    flex: 1,
    position: 'relative',
  },
  content: {
    flexGrow: 1,
    overflow: 'auto',
  },
  header: {
    display: 'flex',
    justifyContent: 'space-between',
    alignItems: 'center',
    mb: 2,
  },
};
export const mainContainerStyles = {
  root: (isDrawerOpen: boolean, drawerWidth: number): SxProps<Theme> => ({
    height: `calc(100vh - ${HEADER.H_DESKTOP + 20}px)`,
    width: isDrawerOpen ? `calc(100% - ${drawerWidth}px)` : '100%',
    display: 'flex',
    flexDirection: 'column',
    overflow: 'hidden',
  }),
};

export const calendarStyles = {
  container: {
    display: 'flex',
    position: 'relative',
    height: '100%',
    width: '100%',
    borderRadius: '12px',
    borderTopLeftRadius: '0px',
    overflow: 'hidden', 
  },
  calendarWrapper: {
    width: '100%',
    height: '100%',
    display: 'flex',
    flexDirection: 'column',
    borderRadius: '12px',
    position: 'relative',
    zIndex: 1,
  },
  content: {
    flex: 1,
    position: 'relative',
    overflow: 'auto',
    backgroundColor: 'white',
    '& .fc': {
      minWidth: '1000px',
      height: '100%',
    },
    '&::-webkit-scrollbar': {
      width: '6px',
      height: '6px',
    },
    '&::-webkit-scrollbar-track': {
      background: 'transparent',
    },
    '&::-webkit-scrollbar-thumb': {
      background: '#bbb',
      borderRadius: '3px',
      '&:hover': {
        background: '#999',
      }
    },
    '&:hover::-webkit-scrollbar-thumb': {
      background: '#999',
    },
  
    scrollbarWidth: 'thin',
    scrollbarColor: '#bbb transparent',
    '&:hover': {
      scrollbarColor: '#999 transparent',
    },
    '&:not(:hover)': {
      '&::-webkit-scrollbar-thumb': {
        background: 'transparent',
      },
      scrollbarColor: 'transparent transparent',
    }
  },
};

export const drawerStyles = {
  content: {
    p: 0, 
    height: '100%',
    display: 'flex',
    flexDirection: 'column',
    overflow: 'auto',
  },
  title: {
    my: 1, 
    ml: 2, 
    color: 'primary.main',
    fontWeight: 'bold',
    fontSize: '1.7rem', 
  },
};
export const tableStyles = {
  root: {
    '& .MuiTableContainer-root': {
      borderRadius: 2,
    },
    '& .MuiTable-root': {
      borderCollapse: 'separate',
      borderSpacing: '0 1px',
      tableLayout: 'auto', 
    },
    '& .MuiTableHead-root': {
      '& .MuiTableCell-root': {
        backgroundColor: 'primary.lighter',
        color: 'primary.main',
        fontWeight: 600,
        fontSize: '0.875rem',
        borderBottom: 'none',
       
      }
    },
    '& .MuiTableBody-root': {
      '& .MuiTableCell-root': {
        '&.flexible-cell': {
          minWidth: 'auto',
          maxWidth: 'none',
          width: 'auto',
        }
      }
    }
  }
};

export const CalendarGlobalStyles = {
  ':root': {
    '--fc-slot-height': '50px',
    '--fc-daygrid-event-height': '28px',
    '--fc-timegrid-event-height': '35px', // NOUVEAU: Variable séparée pour timegrid
    '--event-font-size': '12px',
    '--event-spacing': '2px',
  },
  
  '.fc': {
    '--fc-page-bg-color': 'transparent',
    '--fc-border-color': '#E5E7EB',
    '--fc-daygrid-event-dot-width': '8px',
    '--fc-today-bg-color': '#F3F4F6',
    height: '100%',
    minWidth: 0,
    backgroundColor: 'transparent',
    
 
    overflow: 'hidden',
  },

  '.fc .fc-toolbar.fc-header-toolbar': {
    margin: 0,
    padding: '1rem',
  },
'.fc .fc-scroller': {
    '&::-webkit-scrollbar': {
      width: '6px',
      height: '6px',
    },
    '&::-webkit-scrollbar-track': {
      background: 'transparent',
    },
    '&::-webkit-scrollbar-thumb': {
      background: '#bbb',
      borderRadius: '3px',
      '&:hover': {
        background: '#999',
      }
    },
    scrollbarWidth: 'thin',
    scrollbarColor: '#bbb transparent',
  },
  '.fc .fc-scroller:not(:hover)': {
    '&::-webkit-scrollbar-thumb': {
      background: 'transparent',
    },
    scrollbarColor: 'transparent transparent',
  },
'.fc .fc-col-header': {
    position: 'relative !important',
    backgroundColor: alpha('#746CD4', 0.06),
    transform: 'none !important',
    height: '32px !important',
    minHeight: '32px !important',
    maxHeight: '32px !important',
    overflow: 'visible !important',
    '&::-webkit-scrollbar': {
      width: '6px',
      height: '6px',
    },
    '&::-webkit-scrollbar-track': {
      background: 'transparent',
    },
    '&::-webkit-scrollbar-thumb': {
      background: '#bbb',
      borderRadius: '3px',
      '&:hover': {
        background: '#999',
      }
    },
    '&:not(:hover)': {
      '&::-webkit-scrollbar-thumb': {
        background: 'transparent',
      },
      scrollbarColor: 'transparent transparent',
    },
    scrollbarWidth: 'thin',
    scrollbarColor: '#bbb transparent',
    '&:hover': {
      scrollbarColor: '#999 transparent',
    },
  
  },

  '.fc .fc-scrollgrid-section-header': {
    position: 'relative !important',
    height: '32px !important',
    minHeight: '32px !important',
    maxHeight: '32px !important',
    transform: 'none !important',
    '& > td': {
      height: '32px !important',
      minHeight: '32px !important',
      maxHeight: '32px !important',
      position: 'relative !important',
    },
    '&::-webkit-scrollbar': {
      width: '6px',
      height: '6px',
    },
    '&::-webkit-scrollbar-track': {
      background: 'transparent',
    },
    '&::-webkit-scrollbar-thumb': {
      background: '#bbb',
      borderRadius: '3px',
      '&:hover': {
        background: '#999',
      }
    },
    '&:not(:hover)': {
      '&::-webkit-scrollbar-thumb': {
        background: 'transparent',
      },
      scrollbarColor: 'transparent transparent',
    },
    scrollbarWidth: 'thin',
    scrollbarColor: '#bbb transparent',
    '&:hover': {
      scrollbarColor: '#999 transparent',
    },
  
  },
 
 
  '.fc .fc-scrollgrid': {
    '& ::-webkit-scrollbar': {
      display: 'none',
    },
    scrollbarWidth: 'none',
    msOverflowStyle: 'none',
  },


  
  
  '.fc .fc-col-header-cell': {
    height: '32px !important',
    minHeight: '32px !important',
    maxHeight: '32px !important',
    transform: 'none !important',
    backgroundColor: alpha('#746CD4', 0.04),
    border: 'none',
  },
  '.fc-timegrid-body': {
    height: 'auto !important',
    '& .fc-timegrid-slot': {
      height: 'var(--fc-slot-height) !important',
      transition: 'height 0.3s ease',
    },
  },
  '.fc-theme-standard .fc-scrollgrid-section-header > *': {
    height: '32px !important',
  },
  '.fc-theme-standard .fc-scrollgrid-section > td': {
    padding: '0 !important',
  },

  
  '.fc-view-harness': {
    height: 'auto !important',
  },

  '.fc-scrollgrid-sync-table': {
    height: '100% !important',
  },
  '.fc .fc-col-header-cell-cushion': {
    height: '32px !important',
    minHeight: '32px !important',
    maxHeight: '32px !important',
    padding: '0 8px !important',
    margin: '0 !important',
    color: '#000000',
    fontWeight: 500,
    textTransform: 'none',
    width: '100%',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    transform: 'none !important',
    position: 'relative !important',
  },

  '.fc-theme-standard .fc-scrollgrid': {
    border: 'none',
  },
'.fc-scroller': {
    height: 'auto !important',
    '&::-webkit-scrollbar': {
      display: 'none',
    },
    scrollbarWidth: 'none',
    msOverflowStyle: 'none',
  },

 

  '.fc-theme-standard td, .fc-theme-standard th': {
    borderColor: alpha('#746CD4', 0.1),
  },

 

  '.fc .fc-daygrid-day.fc-day-today': {
    backgroundColor: 'rgba(243, 244, 246, 0.3)',
  },

  '.fc-timegrid-event': {
    minHeight: 'var(--fc-timegrid-event-height) !important', // CORRIGÉ: Utiliser la bonne variable
    margin: '0px 0 !important',
    transition: 'all 0.3s ease',
    borderRadius: '4px',
    border: 'none !important',
    overflow: 'hidden',
    position: 'relative !important',
    
    '&:hover': {
      transform: 'scale(1.02)',
      zIndex: 100,
      boxShadow: '0 2px 8px rgba(0,0,0,0.15)',
    },
    
    '& .fc-event-main': {
      padding: '2px 4px !important',
      minHeight: '100%',
      display: 'flex',
      flexDirection: 'column',
      justifyContent: 'center',
      overflow: 'hidden',
    },
    
    '& .fc-event-main-frame': {
      height: '100%',
      minHeight: 'var(--fc-timegrid-event-height)', // CORRIGÉ: Utiliser la bonne variable
      display: 'flex',
      alignItems: 'center',
      gap: '2px',
      overflow: 'hidden',
    },
    
    '& .fc-event-time': {
      fontSize: 'var(--event-font-size)',
      padding: '0 2px',
      overflow: 'hidden',
      whiteSpace: 'nowrap',
      marginRight: '4px',
      flex: '0 0 auto',
      display: 'block !important', // AJOUTÉ: S'assurer que l'heure est visible
    },
    
    '& .fc-event-title': {
      fontSize: 'var(--event-font-size)',
      padding: '0 2px',
      overflow: 'hidden',
      whiteSpace: 'nowrap',
      textOverflow: 'ellipsis',
      flex: '1 1 auto',
      minWidth: 0,
      display: 'block !important', // AJOUTÉ: S'assurer que le titre est visible
    },
  },

  // CORRIGÉ: Améliorer les styles pour les petits zooms
  '.zoom-level-small .fc-timegrid-event': {
    '& .fc-event-title': {
      fontSize: '10px !important',
      display: 'block !important', // IMPORTANT: Ne plus masquer le titre
    },
    '& .fc-event-time': {
      fontSize: '10px !important',
      display: 'block !important', // IMPORTANT: Garder l'heure visible
    },
    '& .fc-event-main': {
      padding: '1px 2px !important',
    },
  },

  '.zoom-level-large .fc-timegrid-event': {
    '& .fc-event-title': {
      display: 'block',
      fontSize: '12px',
    },
    '& .fc-event-main': {
      padding: '3px 6px !important',
    },
  },

  '.fc-timegrid-slot': {
    height: 'var(--fc-slot-height) !important',
    transition: 'height 0.3s ease',
  },

  '.fc-timegrid-slots': {
    '& tr': {
      height: 'var(--fc-slot-height) !important',
    },
  },

  '.fc-timegrid-now-indicator-line': {
    zIndex: 4,
  },
  '.fc-event-mirror': {
    zIndex: 5,
  },
  '.fc-timegrid-event.fc-event-mirror': {
    zIndex: 6,
  },

 
  '.fc-event.fc-event-draggable': {
    cursor: 'move',
  },

  '.fc-daygrid-event': {
    height: 'var(--fc-daygrid-event-height) !important',
    transition: 'all 0.3s ease',
    margin: '1px 0',
    overflow: 'hidden',
    borderRadius: '4px',
    border: 'none !important',
    
    '&:hover': {
      transform: 'scale(1.02)',
      zIndex: 100,
      boxShadow: '0 2px 8px rgba(0,0,0,0.15)',
    },
  },
  '.fc .fc-daygrid-day-number': {
    float: 'left',
    padding: '4px 8px',
  },

  '.fc .fc-daygrid-day-top': {
    display: 'flex',
    flexDirection: 'row',
    justifyContent: 'flex-start', 
  },


  '.fc-daygrid-event-harness': {
    margin: '0 !important',
    overflow: 'hidden',
  },

  '.fc-timegrid-event-harness': {
    margin: '0 !important',
    position: 'absolute !important',
    zIndex: '1 !important',
    overflow: 'hidden',
  },

  '.fc-v-event': {
    '&.fc-timegrid-event': {
      '&.fc-event-start': {
        marginLeft: '0 !important',
      },
      '&.fc-event-end': {
        marginRight: '0 !important',
      },
    },
  },
};

export const calendarHeaderStyles = {
  container: {
    display: 'flex',
    justifyContent: 'space-between',
    alignItems: 'center',
    p: 2,
    borderBottom: '1px solid',
    borderColor: 'divider',
    bgcolor: 'background.paper',
    borderTopRightRadius: '12px',   
    borderBottomLeftRadius: '12px',   
    borderBottomRightRadius: '12px',
  },
  select: {
    minWidth: 120,
    height: 36,
    backgroundColor: 'primary.main', 
    borderRadius: '8px',
    color: 'white', 
    '& .MuiOutlinedInput-root': {
      borderRadius: '8px',
    },
    '& .MuiSelect-select': {
      py: 1,
      color: 'white', 
    },
    '& .MuiSvgIcon-root': { 
      color: 'white',
    },
    '&:hover': {
      backgroundColor: 'primary.dark', 
    },
    '& .MuiOutlinedInput-notchedOutline': { 
      border: 'none',
    },
  },
  title: {
    color: 'primary.main',
    fontWeight: 500,
  },
  button: {
    height: 36,
    borderRadius: '8px',
    textTransform: 'none',
    fontWeight: 500,
    px: 2,
    boxShadow: 'none',
    '&:hover': {
      boxShadow: 'none',
    },
  },
};

export const toolbarStyles = {
  container: {
    display: 'flex',
    justifyContent: 'center',
    pb: 1,
    pt: 2,
    position: 'relative',
    bgcolor: 'transparent',
    borderRadius: '8px',
    px: 2,
  },
  sliderContainer: {
    height: 35,
    width: 300,
    display: 'flex',
    alignItems: 'center',
    mx: 2,
    bgcolor: 'white',
    borderRadius: '20px',
    px: 2,
    boxShadow: '0 1px 3px rgba(0,0,0,0.1)',
  },
  sliderValue: {
    marginLeft: 2,
    color: '#6B7280',
    fontSize: '0.875rem',
    minWidth: '45px',
  },
  buttonGroup: {
    display: 'flex',
    alignItems: 'center',
    gap: 1,
  },
};

