import * as Yup from "yup"

export const appointmentSchema = Yup.object().shape({
  driverName: Yup.string().required("Le chauffeur est requis"),
  type: Yup.string().required("Le type est requis"),
  date: Yup.date().required("La date est requise"),
  time: Yup.string().required("L'heure est requise"),
  status: Yup.string().required("Le statut est requis"),
  comments: Yup.string().nullable(),
  medicalCenterName: Yup.string().when("type", {
    is: "Visite Médicale (médecine du travail)",
    then: (schema) => schema.required("Le centre médical est requis"),
    otherwise: (schema) => schema.nullable(),
  }),
  doctorName: Yup.string().when("type", {
    is: "Visite Médicale (médecine du travail)",
    then: (schema) => schema.required("Le médecin est requis"),
    otherwise: (schema) => schema.nullable(),
  }),
  otherType: Yup.string().when("type", {
    is: "Autre",
    then: (schema) => schema.required("Veuillez préciser le type"),
    otherwise: (schema) => schema.nullable(),
  }),
})
