import React from 'react';
import {
  TableCell,
  Typography,
} from '@mui/material';
import { FormulaireTableRowProps } from '../types';
import { ContratStyledRow } from '@/shared/sections/contract/styles';
import SvgColor from '@/shared/components/svg-color';

export default function FormulaireTableRow({
  row,
  selected,
  onSelectRow,
  handleEdit,
  handleDelete,
  handleView,
  dense,
}: FormulaireTableRowProps) {

  return (
    <>
      <ContratStyledRow hover onDoubleClick={() => handleView(row)} style={{ cursor: 'pointer' }}>
        <TableCell sx={{ whiteSpace: 'nowrap',position: 'relative', py: dense ? 1 : 2 }}>
            <SvgColor
              src="/assets/icons/ic_border.svg"
              sx={{
                position: 'absolute',
                top: 0,
                left: -4,
                height: '100%',
                color: '#1976d2',
              }}
            />
          {row.nom}
        </TableCell>
        <TableCell sx={{ whiteSpace: 'nowrap', py: dense ? 1 : 2 }}>{row.description}</TableCell>
        <TableCell sx={{ whiteSpace: 'nowrap', py: dense ? 1 : 2 }}>
          <a href={row.lien} target="_blank" rel="noopener noreferrer" style={{ color: '#746CD4' }}>
            {row.lien}
          </a>
        </TableCell>
      </ContratStyledRow>
    </>
  );
}