// Centralized constants for candidature field visibility
export const CANDIDATURE_FIELDS = {
  // Fields for À traiter status
  A_TRAITER_SEDENTAIRE: [
    "nom",
    "prenom", 
    "sourceCandidat",
    "codePostal",
    "ville",
    "age",
    "email",
    "telephone",
    "suiviAppel",
    "dateAppelRappel",
    "dateCandidature",
    "document",
    "departement",
    "statut",
    "address",
  ],

  A_TRAITER_CHAUFFEUR: [
    "nom",
    "prenom",
    "sourceCandidat", 
    "codePostal",
    "ville",
    "age",
    "email",
    "telephone",
    "suiviAppel",
    "dateAppelRappel",
    "dateCandidature",
    "dureePermis",
    "proximiteCircuit",
    "document",
    "departement",
    "statut",
    "address",
  ],

  // Fields for Retenu status
  RETENU_CHAUFFEUR: [
    "nom",
    "prenom",
    "sourceCandidat",
    "email",
    "telephone",
    "dureePermis",
    "departement",
    "proximiteCircuit",
    "contrat",
    "document",
    "codePostal",
    "ville", 
    "age",
    "statut",
    "dateHeureRdvAgence",
    "address",
  ],

  RETENU_SEDENTAIRE: [
    "nom",
    "prenom",
    "codePostal",
    "ville",
    "age",
    "telephone", 
    "email",
    "dateHeureRdvAgence",
    "departement",
    "statut",
    "contrat",
    "address",
  ],

  // Fields for Validé status
  VALIDE_CHAUFFEUR: [
    "nom",
    "prenom",
    "sourceCandidat",
    "email",
    "email_pro",
    "telephone",
    "dureePermis",
    "departement",
    "proximiteCircuit",
    "contrat",
    "document",
    "contrat_document",
    "codePostal",
    "ville",
    "age",
    "statut",
    "address",
  ],

  VALIDE_SEDENTAIRE: [
    "nom",
    "prenom",
    "sourceCandidat",
    "codePostal",
    "ville",
    "age",
    "email",
    "email_pro",
    "telephone",
    "contrat",
    "document", 
    "contrat_document",
    "departement",
    "statut",
    "address",
  ],

  // Fields for Absent status
  ABSENT: [
    "nom",
    "prenom",
    "sourceCandidat",
    "codePostal",
    "ville",
    "age",
    "email",
    "telephone",
    "dureePermis",
    "dateHeureRdvAgence",
    "departement",
    "statut",
  ],

  // Fields for Refuse/Blackliste status
  REFUSE_BLACKLISTE: [
    "nom",
    "prenom",
    "sourceCandidat",
    "telephone",
    "departement",
    "email",
    "raisonRefus",
    "statut",
    "address",
  ],
};

// Helper function to get fields based on status and type
export const getCandidatureFieldsForStatus = (
  statut: string,
  isSedentaire: boolean
): string[] => {
  switch (statut) {
    case 'À traiter':
      return isSedentaire 
        ? [...CANDIDATURE_FIELDS.A_TRAITER_SEDENTAIRE]
        : [...CANDIDATURE_FIELDS.A_TRAITER_CHAUFFEUR];
    
    case 'Retenu':
      return isSedentaire
        ? [...CANDIDATURE_FIELDS.RETENU_SEDENTAIRE]
        : [...CANDIDATURE_FIELDS.RETENU_CHAUFFEUR];
    
    case 'Validé':
      return isSedentaire
        ? [...CANDIDATURE_FIELDS.VALIDE_SEDENTAIRE]
        : [...CANDIDATURE_FIELDS.VALIDE_CHAUFFEUR];
    
    case 'Absent':
      return [...CANDIDATURE_FIELDS.ABSENT];
    
    case 'Refusé':
    case 'Blacklisté':
      return [...CANDIDATURE_FIELDS.REFUSE_BLACKLISTE];
    
    default:
      return [];
  }
}; 