import { CandidatureStatut, ICandidature, IFormulaire } from '@/shared/types/candidature';
import { FormFieldType } from '@/shared/types/common';
import { faFileLines, faLink, faFont } from '@fortawesome/free-solid-svg-icons';

export const formFieldsFormulaire: FormFieldType<IFormulaire>[] = [
  {
    name: 'nom',
    label: 'Nom du formulaire',
    type: 'text',
    placeholder: 'Entrez le nom du formulaire',
    required: true,
    icon: faFont,
  },
  {
    name: 'lien',
    label: 'Lien du formulaire',
    type: 'text',
    placeholder: 'Entrez le lien du formulaire',
    required: true,
    icon: faLink,
  },
  {
    name: 'description',
    label: 'Description',
    type: 'textarea',
    placeholder: 'Entrez une description du formulaire',
    icon: faFileLines,
  },
];

export const getCandidatureFields = (isSedentaire: boolean): FormFieldType<ICandidature>[] => [
  {
    name: 'nom',
    label: 'Nom',
    type: 'text',
    required: true,
    showWhen: () => true,
  },
  {
    name: 'prenom',
    label: 'Prénom',
    type: 'text',
    required: true,
    showWhen: () => true,
  },
  {
    name: 'sourceCandidat',
    label: 'Source candidat',
    type: 'text',
    required: true,
    showWhen: () => true,
  },
  {
    name: 'email',
    label: 'Email',
    type: 'text',
    required: true,
    showWhen: () => true,
  },
  {
    name: 'email_pro',
    label: 'Email Pro',
    type: 'text',
    required: false,
    showWhen: (formData) => formData?.statut === CandidatureStatut.Valide,
  },
  {
    name: 'telephone',
    label: 'Téléphone',
    type: 'text',
    required: true,
    showWhen: () => true,
  },
  {
    name: 'codePostal',
    label: 'Code postal',
    type: 'text',
    required: true,
    placeholder: '60000',
    showWhen: () => true,
  },
  {
    name: 'ville',
    label: 'Ville',
    type: 'text',
    required: true,
    showWhen: () => true,
  },
  {
    name: 'age',
    label: 'Age',
    type: 'number',
    required: true,
    showWhen: () => true,
  },
   {
     name: 'departement',
     label: 'Département',
     type: 'select',
     required: false,
     showWhen: () => true,
   },
  {
    name: 'document',
    label: 'Document',
    type: 'custom',
    showWhen: () => true,
  },
  {
    name: 'address',
    label: 'Adresse',
    type: 'address',
    required: true,
    showWhen: () => true,
  },
  {
    name: 'contrat_document',
    label: 'Contrat',
    type: 'custom',
    showWhen: (formData) => formData?.statut === CandidatureStatut.Valide,
  },
  {
    name: 'suiviAppel',
    label: "Suivi d'appel",
    type: 'select',
    required: false,
    options: [
      { value: 'Premier contact', label: 'Premier contact' },
      { value: 'Rappel planifié', label: 'Rappel planifié' },
      { value: 'Candidat intéressé', label: 'Candidat intéressé' },
      { value: 'Candidat non intéressé', label: 'Candidat non intéressé' },
      { value: 'Pas de réponse', label: 'Pas de réponse' },
      { value: 'Numéro non valide', label: 'Numéro non valide' },
      { value: 'À rappeler', label: 'À rappeler' },
    ],
    showWhen: (formData) => formData?.statut === CandidatureStatut.ATraiter,
  },
  {
    name: 'dateAppelRappel',
    label: 'Date appel ou rappel',
    type: 'date',
    required: false,
    showWhen: (formData) => formData?.statut === CandidatureStatut.ATraiter,
  },
  {
    name: 'dateCandidature',
    label: 'Date de candidature',
    type: 'date',
    required: true,
    showWhen: (formData) => formData?.statut === CandidatureStatut.ATraiter,
  },
  {
    name: 'dureePermis',
    label: 'Durée de permis (en années)',
    type: 'text',
    required: true,
    placeholder: 'Ex: 5',
    showWhen: (status) => !isSedentaire,
  },
  {
    name: 'proximiteCircuit',
    label: 'À proximité du circuit',
    type: 'text',
    required: false,
    showWhen: (status) => !isSedentaire,
  },
  {
    name: 'statut',
    label: 'Statut',
    type: 'select',
    required: true,
    options: [
      { value: CandidatureStatut.ATraiter, label: 'À traiter' },
      { value: CandidatureStatut.EnCours, label: 'En cours' },
      { value: CandidatureStatut.Retenu, label: 'Retenu' },
      { value: CandidatureStatut.Valide, label: 'Validé' },
      { value: CandidatureStatut.Refuse, label: 'Refusé' },
      { value: CandidatureStatut.Blackliste, label: 'Blacklisté' },
      { value: CandidatureStatut.Absent, label: 'Absent' },
    ],
    showWhen: () => true,
  },
  {
    name: 'dateHeureRdvAgence',
    label: 'Replanifier un RDV',
    type: 'datetime',
    required: true,
    showWhen: (formData) =>
      [CandidatureStatut.Retenu, CandidatureStatut.Valide, CandidatureStatut.Absent].includes(
        formData?.statut
      ),
  },
  {
    name: 'raisonRefus',
    label: 'Raison du refus',
    type: 'textarea',
    required: true,
    showWhen: (formData) =>
      [CandidatureStatut.Refuse, CandidatureStatut.Blackliste].includes(formData?.statut),
  },
  {
    name: 'contrat',
    label: 'Statut du contrat',
    type: 'select',
    required: true,
    options: [
      { value: 'signé', label: 'Signé' },
      { value: 'non signé', label: 'Non signé' },
    ],
    showWhen: (formData) =>
      formData?.statut === CandidatureStatut.Valide ||
      formData?.statut === CandidatureStatut.Retenu,
  },
  {
    name: 'disponibilite',
    label: 'Disponibilité',
    type: 'text',
    required: false,
    showWhen: (formData) =>
      [CandidatureStatut.ATraiter, CandidatureStatut.Retenu].includes(formData?.statut),
  },
];
