import { Chip } from '@mui/material';
import { styled } from '@mui/system';

export const SalarieStatusChip = styled(Chip)(({ status, theme, width }: { status: string; theme: any, width?: string }) => ({
  '&.MuiChip-root': {
    fontWeight: 500,
    borderRadius: '8px',
    padding: '9px 0',
    height: '100%',
    width: width || '100%',
    // Original statuses
    ...((status === 'Salarié' || status === 'contrat' || status === 'RH' || status === 'traité') && {
      backgroundColor: '#E9FBF0',
      color: '#36B37E',
    }),
    ...((status === 'Sorti' || status === 'attestation' || status === 'PAIE' || status === 'non traité') && {
      backgroundColor: '#FEF8E7',
      color: '#F9B90B',
    }),
    ...((status === 'Archivé' || status === 'fiche de paie') && {
      backgroundColor: '#FFE1E1',
      color: '#FF3434',
    }),
    ...(status === 'autre' && {
      backgroundColor: '#F4F6F8',
      color: '#637381',
    }),
    // Document Request Statuses
    ...((status === 'PENDING' || status === 'EN_ATTENTE') && {
      backgroundColor: '#FEF8E7',
      color: '#F9B90B',
    }),
    ...((status === 'PROCESSING' || status === 'EN_TRAITEMENT') && {
      backgroundColor: '#EEF1FF',
      color: '#5176FE',
    }),
    ...((status === 'APPROVED' || status === 'VALIDEE') && {
      backgroundColor: '#E9FBF0',
      color: '#36B37E',
    }),
    ...((status === 'REJECTED' || status === 'REFUSEE') && {
      backgroundColor: '#FFE1E1',
      color: '#FF3434',
    }),
    // Request Types
    ...((status === 'PERSONAL_JUSTIFICATION') && {
      backgroundColor: '#E8F5E8',
      color: '#2E7D32',
    }),
    ...((status === 'OFFICIAL_DOCUMENT') && {
      backgroundColor: '#E3F2FD',
      color: '#1976D2',
    }),
    ...((status === 'ADMINISTRATIVE_FILE') && {
      backgroundColor: '#FFF3E0',
      color: '#F57C00',
    }),
    ...((status === 'EMPLOYMENT_CONTRACT') && {
      backgroundColor: '#F3E5F5',
      color: '#7B1FA2',
    }),
    ...((status === 'OTHER') && {
      backgroundColor: '#F5F5F5',
      color: '#616161',
    }),
  },
}));
