import { FormFieldType } from "@/shared/types/common"
import { Candidat } from "@/shared/types/candidat"
import { 
  faUser, 
  faIdCard, 
  faEnvelope, 
  faPhone, 
  faLocationDot, 
  faCalendarDays,
  faIdBadge,
  faCreditCard,
  faCarSide,
  faPassport,
  faMoneyBill,
  faFileContract,
  faAddressCard,
  faHospital,
  faBuildingColumns,
  faUserTie,
  faHome,
  faBuilding
} from '@fortawesome/free-solid-svg-icons';
import { FUEL_CARDS, FUEL_CARDS_OPTIONS, FUEL_TYPES } from "@/shared/_mock";

export const candidatFormFields: FormFieldType<Candidat>[] = [
  {
    name: 'numeroSalarié',
    label: 'Numéro Salarié',
    type: 'text',
    icon: faIdBadge,
    placeholder: 'Numéro généré automatiquement',
    disabled: true, // Read-only field
  },
  {
    name: 'civilite',
    label: 'Civilité',
    type: 'select',
    required: true,
    options: [
      { value: 'M', label: 'M.' },
      { value: 'Mme', label: 'Mme' },
      { value: 'Mlle', label: 'Mlle' },
    ],
  },
  {
    name: 'nom',
    label: 'Nom',
    type: 'text',
    required: true,
    icon:faUserTie
  },
  {
    name: 'type',
    label: 'Type',
    type: 'select',
    required: true,
    options: [
      { value: 'sedentaire', label: 'Sédentaire' },
      { value: 'chauffeur', label: 'Chauffeur' }
    ]
  },
  { name: "prenom", label: "Prénom", type: "text", required: true, icon: faUser, placeholder: "Entrez le prénom" },
  { name: "villeNaissance", label: "Ville de naissance", type: "text", required: true, icon: faLocationDot, placeholder: "Entrez la ville de naissance" },
  { name: "dateNaissance", label: "Date de naissance", type: "date", required: true, icon: faCalendarDays, placeholder: "JJ/MM/AAAA" },
  { name: "nationalite", label: "Nationalité", type: "text", required: true, icon: faPassport, placeholder: "Entrez la nationalité" },
  { name: "email", label: "E-mail", type: "text", required: true, icon: faEnvelope, placeholder: "exemple@email.com" },
  { name: "telephone", label: "Téléphone", type: "text", required: true, icon: faPhone, placeholder: "Entrez le numéro de téléphone" },
  { name: "adresse", label: "Adresse", type: "address", required: true, icon: faLocationDot, placeholder: "Entrez l'adresse" },
  { name: "codePostal", label: "Code postal", type: "text", required: true, icon: faLocationDot, placeholder: "Entrez le code postal" },
  { name: "ville", label: "Ville", type: "text", required: true, icon: faLocationDot, placeholder: "Entrez la ville" },
  { name: "dureePermis", label: "Durée de permis", type: "text", icon: faCarSide, placeholder: "Entrez la durée du permis" },
  { name: "numeroPermis", label: "N° Permis", type: "text", icon: faIdCard, placeholder: "Entrez le numéro de permis" },
  { name: "numeroSS", label: "N° S.S", type: "text", required: true, icon: faCreditCard, placeholder: "Entrez le numéro de sécurité sociale" },
  { name: "dateDebutContrat", label: "Date début contrat", type: "date", required: true, icon: faFileContract, placeholder: "JJ/MM/AAAA" },
  { name: "dateSignatureContrat", label: "Date Signature contrat", type: "date", required: true, icon: faFileContract, placeholder: "JJ/MM/AAAA" },
  { name: "dateInscription", label: "Date d'inscription", type: "date", icon: faCalendarDays, placeholder: "JJ/MM/AAAA", disabled: true },
  { name: "status", label: "Statut", type: "select", required: true, icon: faUserTie, options: [
    { value: "Salarié", label: "Salarié" },
    { value: "Sorti", label: "Sorti" },
    { value: "Archivé", label: "Archivé" }
  ], placeholder: "Sélectionnez un statut" },
  { name: "tauxHoraire", label: "Taux horaire", type: "number", required: true, icon: faMoneyBill, placeholder: "Entrez le taux horaire" },
  {
    name: 'departement',
    label: 'Département',
    type: 'select',
    required: false,
    placeholder: 'Sélectionnez un département',
    icon: faBuilding,
    options: [], // Will be populated dynamically
  },
  {
    name: 'fuelCard',
    label: 'Type de carburant',
    type: 'multiple',
    placeholder: 'Choisissez un ou plusieurs types',
    required: true,
    options:FUEL_TYPES
    
  },
  { 
    name: "cni", 
    label: "CNI (document)", 
    type: "file",
    accept: ".pdf,.jpg,.jpeg,.png",
    icon: faAddressCard,
    placeholder: "Importez votre carte d'identité"
  },
  { 
    name: "permisConduire", 
    label: "Permis de conduire (document)", 
    type: "file",
    accept: ".pdf,.jpg,.jpeg,.png",
    icon: faCarSide,
    placeholder: "Importez votre permis de conduire"
  },
  { 
    name: "carteVitale", 
    label: "Carte vitale ou attestation de sécurité (document)", 
    type: "file",
    accept: ".pdf,.jpg,.jpeg,.png",
    icon: faHospital,
    placeholder: "Importez votre carte vitale ou attestation"
  },
  { 
    name: "rib", 
    label: "RIB (document)", 
    type: "file",
    accept: ".pdf,.jpg,.jpeg,.png",
    icon: faBuildingColumns,
    placeholder: "Importez votre RIB"
  }

] 