import * as Yup from "yup"
import { type Candidat } from "@/shared/types/candidat"

export const salarieSchema = Yup.object().shape({
  civilite: Yup.string().required('La civilité est requise'),
  nom: Yup.string().required('Le nom est requis'),
  prenom: Yup.string().required('Le prénom est requis'),
  type: Yup.string().required('Le type est requis'),
  villeNaissance: Yup.string().required('La ville de naissance est requise'),
  dateNaissance: Yup.date().required('La date de naissance est requise'),
  nationalite: Yup.string().required('La nationalité est requise'),
  email: Yup.string().email('Email invalide').required('L\'email est requis'),
  telephone: Yup.string().required('Le téléphone est requis'),
  adresse: Yup.object().shape({
    address: Yup.string().required('L\'adresse est requise'),
    lat: Yup.number(),
    lng: Yup.number(),
  }),
  codePostal: Yup.string().required('Le code postal est requis'),
  ville: Yup.string().required('La ville est requise'),
  dureePermis: Yup.string().when('type', {
    is: 'chauffeur',
    then: (schema) => schema.required('La durée du permis est obligatoire pour un chauffeur'),
    otherwise: (schema) => schema.nullable(),
  }),
  numeroPermis: Yup.string().when('type', {
    is: 'chauffeur',
    then: (schema) => schema.required('Le numéro de permis est obligatoire pour un chauffeur'),
    otherwise: (schema) => schema.nullable(),
  }),
  numeroSS: Yup.string().required('Le numéro de sécurité sociale est requis'),
  dateDebutContrat: Yup.date().required('La date de début de contrat est requise'),
  dateSignatureContrat: Yup.date().required('La date de signature du contrat est requise'),
  status: Yup.string().required('Le statut est requis'),
  tauxHoraire: Yup.number()
    .required('Le taux horaire est requis')
    .min(0, 'Le taux horaire doit être positif'),
  departement: Yup.string(),
  fuelCard: Yup.array().when('type', {
    is: 'chauffeur',
    then: (schema) => schema.min(1, 'Au moins un type de carburant doit être sélectionné'),
    otherwise: (schema) => schema.nullable(),
  }),
  cni: Yup.mixed().nullable(), // Optional for updates
  permisConduire: Yup.mixed().nullable(), // Optional for updates
  carteVitale: Yup.mixed().nullable(), // Optional for updates
  rib: Yup.mixed().nullable(), // Optional for updates
}) 