import theme from '@/shared/theme';
import { pxToRem } from '@/shared/theme/typography';
import { PrioriteDemande } from '@/shared/types/demande';
import { Chip, Dialog, DialogTitle, TextField, Theme } from '@mui/material';
import { alpha, styled } from '@mui/system';

// Add category mapping
export const CategoryMapping = {
  RECRUITMENT: 'Recrutement',
  EVALUATION: 'Évaluation',
  TRAINING: 'Formation',
  LEAVE: 'Congés',
  ADMINISTRATION: 'Administration',
  OTHER: 'Autre'
};

export const StatusChip = styled(Chip)(
  ({ status, theme, width }: { status: string; theme: any; width?: string }) => ({
    '&.MuiChip-root': {
      fontWeight: 500,
      borderRadius: '8px',
      padding: '9px 0',
      height: '100%',
      width: width || '100%',
      ...((status === 'En attente' || status === 'EVALUATION') && {
        backgroundColor: '#FEF8E7',  
        color: '#F9B90B',  
      }),
      ...((status === 'Approuvée' || status === 'Validée' || status === 'LEAVE' || status === PrioriteDemande.NORMALE) && {
        backgroundColor: '#E9FBF0',
        color: '#36B37E',
      }),
      ...((status === 'Refusé' || status === 'Refusée' || status === 'RECRUITMENT' || status === PrioriteDemande.URGENTE) && {
        backgroundColor: '#FFE1E1', 
        color: '#FF3434',
      }),
      ...((status === 'TRAINING' || status === PrioriteDemande.HAUTE) && {
        backgroundColor: '#FEF8E7',
        color: '#F9B90B',
      }),
      ...((status === 'ADMINISTRATION' || status === PrioriteDemande.BASSE) && {
        backgroundColor: '#EEF1FF',
        color: '#5176FE',
      }),
      ...(status === 'OTHER' && {
        backgroundColor: '#E0E0E0',
        color: '#666666',
      }),
      // Priority Levels
      ...((status === 'LOW' || status === 'BASSE') && {
        backgroundColor: '#E8F5E8',
        color: '#2E7D32',
      }),
      ...((status === 'MEDIUM' || status === 'NORMALE') && {
        backgroundColor: '#E3F2FD',
        color: '#1976D2',
      }),
      ...((status === 'HIGH' || status === 'HAUTE') && {
        backgroundColor: '#FFF3E0',
        color: '#F57C00',
      }),
      ...((status === 'Urgent' || status === 'URGENTE') && {
        backgroundColor: '#FFE1E1',
        color: '#FF3434',
      }),
    },
  })
);

export const getStatusColor = (status: string) => {
  switch (status) {
    case 'RECRUITMENT':
      return '#FF3434';
    case 'EVALUATION':
      return '#F9B90B';
    case 'TRAINING':
      return '#F9B90B';
    case 'LEAVE':
      return '#36B37E';
    case 'ADMINISTRATION':
      return '#5176FE';
    case 'OTHER':
      return '#666666';
    case 'Approuvée':
    case 'Validée':
      return '#36B37E';  
    case 'Refusé':
    case 'Refusée':
      return '#FF3434'; 
    case 'En attente':
      return '#F9B90B';  
    default:
      return '#81919A'; 
  }
};

export const StyledDialogTitle = styled(DialogTitle)(({ theme }) => ({
  fontSize:  pxToRem(25),
  margin: 'auto',
  color: theme.palette.primary.main,
  fontWeight: 700,
}));

export const StyledDialog = styled(Dialog)(({ theme }) => ({
  '& .MuiDialog-paper': {
    borderRadius: theme.spacing(1),
    maxHeight: 'calc(100vh - 90px)',
  },
}));

export const StyledDialogTitleGrey = styled(DialogTitle)(({ theme }) => ({
  padding: theme.spacing(2),
  display: 'flex',
  justifyContent: 'space-between',
  alignItems: 'center',
  flexShrink: 0,
  backgroundColor: theme.palette.grey[200],
}));

export const WhiteStyledTextField = styled(TextField)(({ theme }) => ({
  "& .MuiOutlinedInput-root": {
    borderRadius: "8px",    
    backgroundColor: "white",
    "& .MuiOutlinedInput-input": {
      marginTop: "12px",
      marginBottum: "16px",
      padding: '10px 14px 8px',
    },

    "& fieldset": {
      borderColor: theme.palette.primary.main,
    },
    "&:hover fieldset": {
      borderColor: theme.palette.primary.main,
    },
    "&.Mui-focused fieldset": {
      borderColor: theme.palette.primary.main,
    },
    "& .MuiOutlinedInput-notchedOutline": {
      borderColor: theme.palette.primary.main,
      borderRadius: "12px",
      "& legend": {
        width: 0,
      },
    },
  },

  "& .MuiInputLabel-root": {
    transform: "translate(14px, 4px) scale(0.8)",
    color: theme.palette.primary.main,
  },
  "& .MuiInputLabel-asterisk": {
    color: "#FF0000",
  },
}))

export const MapStyledTextField = styled(TextField)(({ theme }) => ({
  "& .MuiOutlinedInput-root": {
    borderRadius: "8px",    
    backgroundColor: "white",

    "& fieldset": {
      borderColor: theme.palette.primary.main,
    },
    "&:hover fieldset": {
      borderColor: theme.palette.primary.main,
    },
    "&.Mui-focused fieldset": {
      borderColor: theme.palette.primary.main,
    },
  },

  "& .MuiInputLabel-root": {
    transform: "translate(14px, 4px) scale(0.8)",
    color: theme.palette.primary.main,
  },
  "& .MuiInputBase-input": {
    padding: "10px 14px",
  },
}))
