import * as Yup from 'yup';
import { IDemandeAbsence, LeaveType } from '@/shared/types/leave';

export const absenceSchema = Yup.object().shape({
  requestType: Yup.string()
    .required('Le type de demande est requis'),
  absenceType: Yup.string()
    .when('requestType', {
      is: 'Absence',
      then: (schema) => schema.required('Le type d\'absence est requis'),
      otherwise: (schema) => schema.notRequired(),
    }),
  leaveType: Yup.string()
    .when('requestType', {
      is: 'Congé',
      then: (schema) => schema.required('Le type de congé est requis'),
      otherwise: (schema) => schema.notRequired(),
    }),
  otherLeaveDescription: Yup.string()
    .when(['requestType', 'leaveType'], {
      is: (requestType: string, leaveType: string) => 
        requestType === 'Congé' && leaveType === LeaveType.OTHER,
      then: (schema) => schema
        .required('La description du congé est requise')
        .min(10, 'La description doit contenir au moins 10 caractères')
        .max(500, 'La description ne doit pas dépasser 500 caractères'),
      otherwise: (schema) => schema.notRequired(),
    }),
  otherAbsenceDescription: Yup.string()
    .when(['requestType', 'absenceType'], {
      is: (requestType: string, absenceType: string) => 
        requestType === 'Absence' && absenceType === 'OTHER',
      then: (schema) => schema
        .required('La description de l\'absence est requise')
        .min(10, 'La description doit contenir au moins 10 caractères')
        .max(500, 'La description ne doit pas dépasser 500 caractères'),
      otherwise: (schema) => schema.notRequired(),
    }),
  startDate: Yup.date()
    .required('La date de début est requise'),
  endDate: Yup.date()
    .required('La date de fin est requise')
    .min(Yup.ref('startDate'), 'La date de fin doit être postérieure à la date de début'),
  daysCount: Yup.number()
    .required('Le nombre de jours est requis')
    .min(0, 'Le nombre de jours doit être positif'),
  status: Yup.string()
    .required('Le statut est requis'),
  reason: Yup.string()
    .max(500, 'Le motif ne doit pas dépasser 500 caractères'),
}); 