// Updated demande-details.tsx to remove intitule and use IDocumentRequest
import type React from "react";
import { Grid } from "@mui/material";
import type { IDocumentRequest } from "@/shared/types/document-request";
import type { FormFieldType, ModeType } from "@/shared/types/common";

interface DemandeDetailsFormProps {
  renderField: (field: FormFieldType<any>) => React.ReactNode;
  mode: ModeType;
  onEdit: () => void;
  onClose: () => void;
  onSave: () => void;
  demande: IDocumentRequest;
}

// Adjusted fields to match new interface (IDocumentRequest)
const demandeFormFields: FormFieldType<IDocumentRequest>[] = [
  {
    name: "description",
    label: "Description",
    type: "text",
    required: true,
  },
  {
    name: "createdAt",
    label: "Date de Création",
    type: "date",
    required: true,
  },
  {
    name: "processingDate",
    label: "Date d'expiration",
    type: "date",
    required: false,
  },
];

export default function DemandeDetailsForm({
  renderField,
  mode,
  onEdit,
  onClose,
  onSave,
  demande,
}: DemandeDetailsFormProps) {
  const isReadOnly = mode === "view";

  return (
    <Grid container spacing={3}>
      {demandeFormFields.map((field) => (
        <Grid item xs={12} sm={6} key={field.name}>
          {renderField(field)}
        </Grid>
      ))}
    </Grid>
  );
}
