"use client"

import {
  Dialog,
  DialogTitle,
  DialogContent,
  DialogActions,
  Button,
  Typography,
  Box,
} from "@mui/material"
import { Warning as WarningIcon } from "@mui/icons-material"
import { useState } from "react"

interface ConfirmDocumentDeleteDialogProps {
  open: boolean
  onClose: () => void
  onConfirm: () => void
  documentName: string
}

export default function ConfirmDocumentDeleteDialog({
  open,
  onClose,
  onConfirm,
  documentName,
}: ConfirmDocumentDeleteDialogProps) {
  const handleConfirm = () => {
    onConfirm()
    onClose()
  }

  return (
    <Dialog open={open} onClose={onClose} maxWidth="sm" fullWidth>
      <DialogTitle>
        <Box sx={{ display: "flex", alignItems: "center", gap: 1 }}>
          <WarningIcon color="warning" />
          Confirmer la suppression
        </Box>
      </DialogTitle>
      <DialogContent>
        <Typography>
          Êtes-vous sûr de vouloir supprimer le document{" "}
          <strong>&quot;{documentName}&quot;</strong> ?
        </Typography>
        <Typography variant="body2" color="text.secondary" sx={{ mt: 1 }}>
          Cette action est irréversible.
        </Typography>
      </DialogContent>
      <DialogActions>
        <Button onClick={onClose} color="inherit">
          Annuler
        </Button>
        <Button onClick={handleConfirm} color="error" variant="contained">
          Supprimer
        </Button>
      </DialogActions>
    </Dialog>
  )
}