"use client"

import { Dialog, DialogTitle, DialogContent, IconButton } from "@mui/material"
import CloseIcon from "@mui/icons-material/Close"
import { ContentTypeEnum, DocumentDTO } from "@/shared/types/document"
import { useDocumentStore } from "@/shared/api/stores/document-service/docsStore"
import ConditionalComponent from "@/shared/components/table/ConditionalComponent"

interface DocumentViewerDialogProps {
  open: boolean
  onClose: () => void
  document: DocumentDTO | null
}

export default function DocumentViewerDialog({ open, onClose, document }: DocumentViewerDialogProps) {
  if (!document) return null

  const isImage = document.contentType === "IMAGE";
  const isPdf = document.contentType === "PDF";

  return (
    <Dialog open={open} onClose={onClose} fullWidth maxWidth="lg">
      <DialogTitle sx={{ display: "flex", justifyContent: "space-between", alignItems: "center" }}>
        {document.name}
        <IconButton onClick={onClose}><CloseIcon /></IconButton>
      </DialogTitle>
      <DialogContent dividers sx={{ height: "80vh" }}>
        <ConditionalComponent isValid={isImage}>
          <img
            src={document.downloadUrl}
            alt={document.name}
            style={{ width: "100%", height: "auto", objectFit: "contain" }}
          />
        </ConditionalComponent>
        <ConditionalComponent isValid={isPdf}>
          <iframe
            src={document.downloadUrl}
            width="100%"
            height="100%"
            style={{ border: "none" }}
            title={document.name}
          />
        </ConditionalComponent>
        <ConditionalComponent isValid={!isImage && !isPdf}>
          <iframe
            src={document.downloadUrl}
            width="100%"
            height="100%"
            style={{ border: "none" }}
            title={document.name}
          />
        </ConditionalComponent>
      </DialogContent>
    </Dialog>
  )
}
