import { Box, Typography, LinearProgress, Stack } from "@mui/material"

interface StorageUsageProps {
  usedBytes: number
  totalBytes: number
  usedFormatted: string
  totalFormatted: string
}

export default function StorageUsage({
  usedBytes,
  totalBytes,
  usedFormatted,
  totalFormatted,
}: StorageUsageProps) {
  const usagePercentage = Math.round((usedBytes / totalBytes) * 10000) / 100

  return (
    <Stack direction="column" justifyContent="flex-end" alignItems="center" sx={{ width: '100%' }}>
      <Stack direction="row" justifyContent="center" alignItems="center" spacing={1} sx={{ marginBottom: 1 }}>
        <Box sx={{ typography: 'body', mt: 0.5, fontWeight: 'bold', fontSize: '1.3rem' }}>{usedFormatted}</Box>
        <Box sx={{ typography: 'body2', color: 'text.disabled', mt: 0.5 }}>
          utilisé(s) sur {totalFormatted}
        </Box>
      </Stack>
      <LinearProgress
        variant="determinate"
        value={usagePercentage}
        color="primary"
        sx={{
          width: '100%',
          height: 8,
          '@media (min-width: 1200px)': {
            width: '30%',
          },
        }}
      />
    </Stack>
  )
}
