"use client";

import React from 'react';
import { Box } from '@mui/system';
import { Chip, CircularProgress, Typography } from '@mui/material';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';

export interface UserLeaveByYear {
  absenceType: string | null;
  totalDays: number;
  startDate: string;
  endDate: string;
}

export default function LeavesList({
  title,
  color,
  loading,
  items,
  translateAbsenceType,
  formatDate,
}: {
  title: string;
  color: 'primary' | 'warning';
  loading: boolean;
  items: UserLeaveByYear[];
  translateAbsenceType: (t: string) => string;
  formatDate: (d: string) => string;
}) {
  const paletteKey = color;
  return (
    <>
      <Typography variant="subtitle1" sx={{
        fontWeight: 600,
        color: `${paletteKey}.main`,
        mb: 2,
        display: 'flex',
        alignItems: 'center',
        gap: 1,
      }}>
        <Box sx={{ width: 8, height: 8, borderRadius: '50%', bgcolor: `${paletteKey}.main` }} />
        {title} ({items.length})
      </Typography>

      <ConditionalComponent
        isValid={!loading}
        defaultComponent={
          <Box sx={{ display: 'flex', justifyContent: 'center', py: 3 }}>
            <CircularProgress size={24} />
          </Box>
        }
      >
        <ConditionalComponent
          isValid={items.length > 0}
          defaultComponent={
            <Typography variant="body2" sx={{ color: 'text.secondary', textAlign: 'center', py: 3 }}>
              {title.startsWith('Cong') ? 'Aucun congé enregistré cette année' : 'Aucune absence enregistrée cette année'}
            </Typography>
          }
        >
          <Box sx={{ display: 'flex', flexDirection: 'column', gap: 2 }}>
            {items.map((entry, index) => (
              <Box key={index} sx={{
                p: 2,
                bgcolor: `${paletteKey}.light`,
                borderRadius: 1,
                border: '1px solid',
                borderColor: `${paletteKey}.main`,
              }}>
                <Box sx={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center' }}>
                  <Box>
                    <Typography variant="body2" sx={{ fontWeight: 500 }}>
                      {formatDate(entry.startDate)} - {formatDate(entry.endDate)}
                    </Typography>
                    {entry.absenceType && (
                      <Typography variant="caption" color="text.secondary">
                        Type: {translateAbsenceType(entry.absenceType)}
                      </Typography>
                    )}
                  </Box>
                  <Chip
                    label={`${entry.totalDays} jour${entry.totalDays > 1 ? 's' : ''}`}
                    size="small"
                    variant="filled"
                    sx={{ bgcolor: `${paletteKey}.main`, color: `${paletteKey}.contrastText`, fontWeight: 600 }}
                  />
                </Box>
              </Box>
            ))}
          </Box>
        </ConditionalComponent>
      </ConditionalComponent>
    </>
  );
}


