"use client";

import React from 'react';
import { Dialog, Box, Typography } from '@mui/material';

export default function SettingsDialog({ open, onClose }: { open: boolean; onClose: () => void }) {
  return (
    <Dialog
      open={open}
      onClose={onClose}
      fullWidth
      maxWidth="sm"
      PaperProps={{
        sx: { borderRadius: 2, maxHeight: '80vh' },
      }}
    >
      <Box sx={{ p: 3 }}>
        <Typography variant="h5" component="h2" sx={{ fontWeight: 'bold', mb: 2 }}>
          Paramètres de l&apos;emploi du temps
        </Typography>
        <Typography variant="body1" color="text.secondary">
          Vous pouvez modifier les paramètres de votre emploi du temps ici. Vous pouvez également choisir de masquer ou d&apos;afficher certaines informations.
        </Typography>
      </Box>
    </Dialog>
  );
}


